﻿---
title: Elasticsearch Add-On for Heroku
description: This documentation applies to Heroku users who want to make use of the Elasticsearch Add-On for Heroku that is available from the Heroku Dashboard, or...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Elasticsearch Add-On for Heroku
This documentation applies to Heroku users who want to make use of the Elasticsearch Add-On for Heroku that is available from the [Heroku Dashboard](https://dashboard.heroku.com/), or that can be installed from the CLI.
The add-on runs on Elastic Cloud and provides access to [Elasticsearch](https://www.elastic.co/products/elasticsearch), the open source, distributed, RESTful search engine. Many other features of the Elastic Stack are also readily available to Heroku users through the [Elasticsearch Add-On for Heroku console](https://cloud.elastic.co?page=docs&placement=docs-body) after you install the add-on. For example, you can use Kibana to visualize your Elasticsearch data.
To learn more about what plans are available for Heroku users and their cost, refer to the [Elasticsearch add-on](https://elements.heroku.com/addons/foundelasticsearch) in the Elements Marketplace.
<warning>
  The Elasticsearch Add-on for Heroku has several limitations that do not apply to [other Elastic Cloud sign-up methods](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/create-an-organization). To get access to all Elastic Cloud functionality, consider signing up using another method.
</warning>


## Limitations

Not all features of Elastic Cloud are available to Heroku users. Specifically, you cannot create additional deployments or use different deployment templates.
Generally, if a feature is shown as available in the [Elasticsearch Add-on for Heroku console](https://cloud.elastic.co?page=docs&placement=docs-body), you can use it.
[Elasticsearch Machine Learning](https://www.elastic.co/docs/explore-analyze/machine-learning), [Elastic APM](https://www.elastic.co/docs/solutions/observability/apm) and [Elastic Fleet Server](https://www.elastic.co/docs/reference/fleet) are not supported by the Elasticsearch Add-On for Heroku.
For other restrictions that apply to all of Elastic Cloud, refer to [Restrictions and known problems](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/restrictions-known-problems).

## Get started

To get started with the Elasticsearch Add-on for Heroku, [install the add-on](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-getting-started-installing).
After you install, you can access your deployment:
- [Access the console](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-getting-started-accessing): Access the Elastic Cloud Console for your Elasticsearch Add-On for Heroku deployment.
- [Work with Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-working-with-elasticsearch): Retrieve  the Elasticsearch endpoint address and send requests to Elasticsearch.
- [Access Kibana on Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/access-kibana): Access Kibana.
- [Access the API console](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-console): Access the API console to make requests without logging into your deployment.


## Heroku-specific hardware and regions

The Elasticsearch Add-on for Heroku in on specific AWS regions only. To learn about the supported AWS regions and hardware, refer to the following pages:
- [Elasticsearch Add-on for Heroku hardware](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-reference-hardware)
- [Elasticsearch Add-on for Heroku regions](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-reference-regions)


## More about Elastic Cloud Hosted

Find more information about Elastic Cloud Hosted on the following pages. This information is subject to the Elasticsearch Add-on for Heroku [limitations](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku).
- [Learn the basics of operating an Elastic Cloud Hosted deployment](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/cloud-hosted)
- [Manage deployments in Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/manage-deployments)
- [Licenses and subscriptions](https://www.elastic.co/docs/deploy-manage/license)
- [Available stack versions](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/available-stack-versions)
- [Service status](https://www.elastic.co/docs/deploy-manage/cloud-organization/service-status)
- [Get help](https://www.elastic.co/docs/troubleshoot)


## Next steps

After have provisioned your first deployment, you’re ready to index data into the deployment and explore the advanced capabilities of Elasticsearch Add-on for Heroku.

### Index data

There are several ways to ingest data into the deployment:
- Use the sample data available from the Kibana home page without loading your own data. There are multiple data sets available and you can add them with one click.
- Ingest your own data. [Learn more](https://www.elastic.co/docs/manage-data/ingest).
- Have existing Elasticsearch data? Consider your [migration options](https://www.elastic.co/docs/manage-data/migrate).


### Increase security

You might want to add more layers of security to your deployment, such as:
- Add more users to the deployment with third-party authentication providers and services like [SAML](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/saml), [OpenID Connect](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/openid-connect), or [Kerberos](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kerberos).
- Do not use clients that only support HTTP to connect to Elastic Cloud. If you need to do so, you should use a reverse proxy setup.
- Create [network security policies](https://www.elastic.co/docs/deploy-manage/security/network-security) and apply them to your deployments.
- If needed, you can [reset](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users) the `elastic` password.


### Scale or adjust your deployment

You might find that you need a larger deployment for the workload, or [upgrade the Elasticsearch version](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-ech) for the latest features. All of this can be done after provisioning by [changing your deployment configuration](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/manage-deployments).