﻿---
title: Elasticsearch Add-on for Heroku regions
description: A region is the geographic area where the data center of the cloud provider that hosts your deployment is located. Use the information listed here to...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-reference-regions
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Elasticsearch Add-on for Heroku regions
A region is the geographic area where the data center of the cloud provider that hosts your deployment is located. Use the information listed here to decide which Elasticsearch Add-on for Heroku region to use. Your choice should be based on:
- Your geographic proximity to the region. Picking a region that is closer to you typically reduces latency for indexing and search requests.
- The features that we support for the region. Not all regions support the same set of features.

Elasticsearch Add-on for Heroku handles all hosting details for you, no additional accounts with the underlying cloud provider required. The region you select cannot be changed after you create a deployment. If you want to use a different region later on, you can create a new deployment and reindex your data into it.
<tip>
  If you are not sure what to pick, choose a region that is geographically close to you to reduce latency. You should always use HTTPS to connect to the Elastic Stack components of your deployment.
</tip>


## Amazon Web Services (AWS) regions

The following AWS regions are available:

| Region    | Name                  | Supports   |
|-----------|-----------------------|------------|
| eu-west-1 | EU (Ireland)          | HTTPS only |
| us-east-1 | US East (N. Virginia) | HTTPS only |