﻿---
title: Elasticsearch Add-on for Heroku hardware
description: Elastic Cloud Hosted deployments use a range of virtualized hardware resources from a cloud provider, such as Amazon EC2 (AWS). Instance configurations...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-reference-hardware
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Elasticsearch Add-on for Heroku hardware
Elastic Cloud Hosted deployments use a range of virtualized hardware resources from a cloud provider, such as Amazon EC2 (AWS). Instance configurations enable the products and features of the Elastic Stack to run on suitable resources that support their intended purpose. For example, if you have a logging use case that benefits from large amounts of slower but more cost-efficient storage space, you can use large spindle drives rather than more expensive SSD storage. Each instance configuration provides a combination of CPU resources, memory, and storage, all of which you can scale from small to very large.
<note>
  All instances are set to UTC timezone.
</note>

The Elasticsearch Add-on for Heroku runs exclusively on AWS. To understand the available hardware, refer to the following resources:
- [The Elastic Cloud Hosted hardware overview](https://www.elastic.co/docs/reference/cloud/cloud-hosted/hardware)
- [AWS hardware](https://www.elastic.co/docs/reference/cloud/cloud-hosted/aws)
- [AWS default hardware](https://www.elastic.co/docs/reference/cloud/cloud-hosted/aws-default)

Some hardware profiles might not be available in your region. To learn about regions used by the Elasticsearch Add-on for Heroku, refer to [Elasticsearch Add-on for Heroku regions](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-reference-regions).