﻿---
title: Install the add-on
description: These steps walk you through installing the Elasticsearch Add-on for Heroku from the Heroku CLI. You can either install the latest default version of...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-getting-started-installing
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Install the add-on
These steps walk you through installing the Elasticsearch Add-on for Heroku from the Heroku CLI. You can either install the latest default version of the add-on or you can install a specific version and include plugins at the same time.

## Before you begin

The installation steps in this section assume that you have a basic working knowledge of the [Heroku CLI](https://devcenter.heroku.com/articles/heroku-cli) and are familiar with using the command line. To work with the Elasticsearch Add-on for Heroku from the command line, you need to have the [Heroku CLI](https://devcenter.heroku.com/articles/heroku-cli) already installed.
If you prefer to install the add-on through your web browser, go to the [Elasticsearch add-on](https://elements.heroku.com/addons/foundelasticsearch) page in the Elements Marketplace, select **Install Elasticsearch**, pick the add-on plan you want, and select **Provision add-on**.

## Steps

To install the latest add-on for `MY_APP` using the Heroku CLI:
```bash
heroku addons:create foundelasticsearch --app MY_APP
```

After the Elasticsearch Add-on for Heroku gets added, you can find the canonical URL you use to access your newly provisioned cluster in the configuration for the app. Look for the `FOUNDELASTICSEARCH_URL` setting when you grep on the output of the `heroku config` command:
```bash
heroku config --app MY_APP | grep FOUNDELASTICSEARCH_URL
FOUNDELASTICSEARCH_URL: <example-url>.aws.found.io
```


## Install a specific version and plugins

If you want your add-on to run a specific version of Elasticsearch, use the `--elasticsearch-version` parameter. We also provide many of the plugins that are available for Elasticsearch. You use the `--plugins` parameter to specify a comma-separated list of plugins that you want installed.
To find which Elasticsearch versions and plugins are currently available, you can omit the version to default to the latest one and add plugins later on from the [Elasticsearch Add-on for Heroku console](https://cloud.elastic.co?page=docs&placement=docs-body). To use your own custom plugins, you can upload and select these plugins in the console as well.
For example: Install the add-on version 9.3.0 and include the phonetic analysis plugin for  MY_APP:
```bash
heroku addons:create foundelasticsearch --elasticsearch-version 9.3.0 --plugins analysis-phonetic --app MY_APP
```

After the add-on gets added, you can perform future version upgrades and plugin changes through the [console](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-getting-started-accessing).

## Next steps

- [Access the console](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-getting-started-accessing)
- [Work with Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-working-with-elasticsearch)
- [Elasticsearch Add-On for Heroku > Next steps](/docs/deploy-manage/deploy/elastic-cloud/heroku#next-steps)

To learn how to remove the add-on, refer to [Remove the add-on](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/heroku-getting-started-removing).