﻿---
title: Edit Elastic Stack settings
description: From the Elastic Cloud Console you can customize Elasticsearch, Kibana, and related products to suit your needs. These editors append your changes to...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/edit-stack-settings
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Edit Elastic Stack settings
From the Elastic Cloud Console you can customize Elasticsearch, Kibana, and related products to suit your needs. These editors append your changes to the appropriate YAML configuration file and they affect all users of that cluster.

## Edit settings

To add or edit user settings:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Find your deployment on the home page or on the **Hosted deployments** page, then select **Manage** to access its settings menus.
   On the **Hosted deployments** page you can narrow your deployments by name, ID, or choose from several other filters. To customize your view, use a combination of filters, or change the format from a grid to a list.
3. Under the deployment's name in the navigation menu, select **Edit**.
4. Look for the **Manage user settings and extensions** and **Edit user settings** links for each deployment, and select the one corresponding to the component you want to update, such as Elasticsearch or Kibana.
5. Apply the necessary settings in the **Users Settings** tab of the editor and select **Back** when finished.
6. Select **Save** to apply the changes to the deployment. Saving your changes initiates a configuration plan change that restarts the affected components for you.

<note>
  In some cases, you may get a warning saying "User settings are different across Elasticsearch instances". To fix this issue, ensure that your user settings (including the comments sections and whitespaces) are identical across all Elasticsearch nodes (not only the data tiers, but also the Master, Machine Learning, and Coordinating nodes).
</note>

<warning>
  You can also update [dynamic cluster settings](/docs/deploy-manage/deploy/self-managed/configure-elasticsearch#dynamic-cluster-setting) using Elasticsearch's [update cluster settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings). However, Elastic Cloud Hosted doesn’t reject unsafe setting changes made using this API. Use it with caution.
</warning>


## Available settings


### Elasticsearch settings

<important>
  If a feature requires both standard `elasticsearch.yml` settings and [secure settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings), configure the secure settings first. Updating standard user settings can trigger a cluster rolling restart, and if the required secure settings are not yet in place, the nodes may fail to start. In contrast, adding secure settings does not trigger a restart.
</important>

Elastic Cloud Hosted automatically rejects `elasticsearch.yml` settings that could break your cluster.
For a list of supported settings, refer to the [Elasticsearch configuration reference](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference). Settings supported on Elastic Cloud Hosted are indicated by an Elastic Cloud icon (![logo cloud](https://doc-icons.s3.us-east-2.amazonaws.com/logo_cloud.svg "Supported on Elastic Cloud")).

### Kibana settings

Elastic Cloud Hosted supports most of the standard Kibana settings.
Be aware that some settings that could break your cluster if set incorrectly and that the syntax might change between major versions.
For a list of supported settings, check [Kibana settings](https://www.elastic.co/docs/reference/kibana/cloud/elastic-cloud-kibana-settings).

### APM settings

Refer to [APM configuration reference](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure) for information on how to configure the Fleet-managed APM integration.