﻿---
title: Compare Elastic Cloud Hosted and Serverless
description: This guide compares Elastic Cloud Hosted deployments with Elastic Cloud Serverless projects, highlighting key features and capabilities across different...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings
products:
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Compare Elastic Cloud Hosted and Serverless
This guide compares Elastic Cloud Hosted deployments with Elastic Cloud Serverless projects, highlighting key features and capabilities across different project types. Use this information to understand what's available in each deployment option or to plan migrations between platforms.
<note>
  The following information reflects our strategic goals, plans and objectives and includes estimated release dates, anticipated features and functions, and proposed descriptions for commercial features. All details are for information only and are subject to change in our discretion. Information might be updated, added, or removed from this document as features or products become available, canceled, or postponed.
</note>


## Architectural differences

Elastic Cloud Serverless takes a fundamentally different approach to running the Elastic Stack compared to Elastic Cloud Hosted:

| **Functionality**                        | Elastic Cloud Hosted                             | Elastic Cloud Serverless                                                                                                   |
|------------------------------------------|--------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------|
| **Management model**                     | Self-service infrastructure                      | Fully managed service                                                                                                      |
| **Project organization**                 | Single deployments with multiple capabilities    | Separate projects for Elasticsearch, Observability, and Security                                                           |
| **Scaling**                              | Manual or automated with configuration           | Fully automated                                                                                                            |
| **Infrastructure decisions**             | User manages capacity                            | Automatically managed by Elastic                                                                                           |
| **Pricing model**                        | Based on provisioned resources                   | Based on usage                                                                                                             |
| **Cloud providers**                      | AWS, Azure, GCP                                  | AWS, Azure, GCP                                                                                                            |
| **Upgrades**                             | User-controlled timing                           | Automatically performed by Elastic                                                                                         |
| **User management**                      | Elastic Cloud-managed and deployment-local users | Elastic Cloud-managed users only. Serverless users are managed at the organization level with SAML authentication support. |
| **Backups**                              | User-managed with Snapshot & Restore             | Automatically backed up by Elastic                                                                                         |
| **Solutions**                            | Full Elastic Stack per deployment                | Single solution per project                                                                                                |
| **Cross-origin resource sharing (CORS)** | Supported                                        | Not available. Browser-based applications must route requests through a backend proxy server.                              |

In Serverless, Elastic automatically manages:
- Cluster scaling and optimization
- Node management and allocation
- Shard distribution and replication
- Resource utilization and monitoring
- High availability and disaster recovery strategies


## Compare features





### Core platform capabilities

This table compares the core platform capabilities between Elastic Cloud Hosted deployments and Serverless projects:

| **Feature**                        | Elastic Cloud Hosted                                   | Serverless projects                      | Notes                                                                                                                                                                                            |
|------------------------------------|--------------------------------------------------------|------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Audit logging**                  | ✅                                                      | **Planned**                              | Anticipated in a future release                                                                                                                                                                  |
| **Authentication realms**          | ✅                                                      | ✅                                        | Managed at organization level in Serverless; deployment level in Hosted                                                                                                                          |
| **BYO-Key for encryption at rest** | ✅                                                      | **Planned**                              | Anticipated in a future release; data in Serverless is stored on cloud-provider encrypted object storage                                                                                         |
| **Cloud provider support**         | - AWS - GCP - Azure                                    | - AWS - Azure - GCP                      | - [Elastic Cloud Hosted regions](https://www.elastic.co/docs/reference/cloud/cloud-hosted/regions)- [Serverless regions](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/regions) |
| **Cluster scaling**                | Manual with autoscaling option                         | Managed                                  | Automatic scaling eliminates capacity planning - [Learn more](https://www.elastic.co/blog/elastic-serverless-architecture)                                                                       |
| **Custom plugins and bundles**     | ✅                                                      | ❌                                        | Not available in Serverless                                                                                                                                                                      |
| **Custom roles**                   | ✅                                                      | ✅                                        |                                                                                                                                                                                                  |
| **Deployment health monitoring**   | AutoOps or monitoring cluster                          | Managed by Elastic                       | - No monitoring cluster required - Automatically handled by Elastic                                                                                                                              |
| **Deployment model**               | Single deployments with multiple solutions             | Separate projects for specific use cases | Fundamental architectural difference - [Learn more](https://www.elastic.co/blog/elastic-serverless-architecture)                                                                                 |
| **Deployment monitoring**          | AutoOps or monitoring cluster                          | Managed                                  | Monitoring is handled by Elastic                                                                                                                                                                 |
| **Email service**                  | ✅                                                      | ✅                                        | Preconfigured email connector available - [Learn more about limits and usage](/docs/deploy-manage/deploy/elastic-cloud/tools-apis#elastic-cloud-email-service)                                   |
| **Hardware configuration**         | Limited control                                        | Managed                                  | Hardware choices are managed by Elastic                                                                                                                                                          |
| **High availability**              | ✅                                                      | ✅                                        | Automatic resilience                                                                                                                                                                             |
| **Network security**               | IP filtering, private connectivity (VPCs, PrivateLink) | IP filtering                             | Private connectivity options anticipated in a future release                                                                                                                                     |
| **Node management**                | User-controlled                                        | Managed                                  | No node configuration access by design                                                                                                                                                           |
| **Snapshot/restore**               | ✅                                                      | **Planned**                              | User-initiated snapshots are anticipated in a future release                                                                                                                                     |

<note>
  The [Elastic Cloud Serverless roadmap](https://www.elastic.co/cloud/serverless/roadmap) primarily focuses on platform capabilities rather than project-specific features. Use the following project-specific tables for information about features for each project type.
</note>


### Elasticsearch

This table compares Elasticsearch capabilities between Elastic Cloud Hosted deployments and Serverless projects:

| **Feature**                                                                                                                                    | Elastic Cloud Hosted                                                                                                                                                           | Serverless Elasticsearch projects                                                           | Serverless notes                                                                                                                                                                        |
|------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [**AI Assistant**](https://www.elastic.co/docs/solutions/observability/ai/observability-ai-assistant)                                          | ✅                                                                                                                                                                              | ✅                                                                                           |                                                                                                                                                                                         |
| **Behavioral analytics**                                                                                                                       | ❌ (deprecated in 9.0)                                                                                                                                                          | ❌                                                                                           | Not available in Serverless                                                                                                                                                             |
| [**Clone index API**](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-clone)                                     | ✅                                                                                                                                                                              | **Planned**                                                                                 | Anticipated in a future release                                                                                                                                                         |
| [**Bulk indexing**](/docs/deploy-manage/production-guidance/optimize-performance/indexing-speed#_use_bulk_requests)                            | ✅                                                                                                                                                                              | ✅                                                                                           | The baseline write latency in Serverless is 200ms [^1^](#footnote-1)                                                                                                                    |
| [**Cross-cluster replication**](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication)                                     | ✅                                                                                                                                                                              | **Planned**                                                                                 | Anticipated in a future release                                                                                                                                                         |
| [**Cross-cluster search**](https://www.elastic.co/docs/explore-analyze/cross-cluster-search)                                                   | ✅                                                                                                                                                                              | **Planned**                                                                                 | Anticipated in a future release                                                                                                                                                         |
| **Data lifecycle management**                                                                                                                  | - [ILM](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) - [Data stream lifecycle](https://www.elastic.co/docs/manage-data/lifecycle/data-stream) | [Data stream lifecycle](https://www.elastic.co/docs/manage-data/lifecycle/data-stream) only | - No data tiers in Serverless - Optimized for common lifecycle management needs                                                                                                         |
| **Elastic connectors (for search)**                                                                                                            | ❌ (Managed connectors discontinued with Enterprise Search in 9.0)                                                                                                              | Self-managed only                                                                           | - Managed connectors not available - Use [**self-managed connectors**](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors)                                 |
| [**Elasticsearch for Apache Hadoop**](https://www.elastic.co/elasticsearch/hadoop)                                                             | ✅                                                                                                                                                                              | ❌                                                                                           | Not available in Serverless                                                                                                                                                             |
| **Enterprise Search (App Search & Workplace Search)**                                                                                          | ❌ (discontinued in 9.0)                                                                                                                                                        | ❌                                                                                           | Not available in Serverless                                                                                                                                                             |
| [**Kibana Alerts**](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts)                       | ✅                                                                                                                                                                              | ✅                                                                                           |                                                                                                                                                                                         |
| [**Reindexing from remote**](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/reindex-indices#reindex-from-remote)                | ✅                                                                                                                                                                              | **Tech Preview**                                                                            |                                                                                                                                                                                         |
| **Repository management**                                                                                                                      | ✅                                                                                                                                                                              | Managed                                                                                     | Automatically managed by Elastic                                                                                                                                                        |
| [**Scripted metric aggregations**](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-scripted-metric-aggregation) | ✅                                                                                                                                                                              | ❌                                                                                           | Not available in ServerlessThe alternative for this in Serverless is [ES|QL](https://www.elastic.co/docs/reference/query-languages/esql)                                                |
| [**`join` fields**](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/parent-join)                                         | ✅                                                                                                                                                                              | ❌                                                                                           | Not available in ServerlessThe alternative for this in Serverless is the ES|QL [`LOOKUP JOIN`](https://www.elastic.co/docs/reference/query-languages/esql/commands/lookup-join) command |
| [**Search applications**](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/search-applications)                            | - UI and APIs - Maintenance mode (beta)                                                                                                                                        | - API-only - Maintenance mode (beta)                                                        | UI not available in Serverless                                                                                                                                                          |
| **Shard management**                                                                                                                           | User-configurable                                                                                                                                                              | Managed by Elastic                                                                          | No manual shard allocation in Serverless                                                                                                                                                |
| [**Synonyms**](https://www.elastic.co/docs/solutions/search/full-text/search-with-synonyms)                                                    | - Index time synonyms - File-based synonyms - Synonyms API                                                                                                                     | Synonyms API only (does not support index-time or file-based synonyms)                      |                                                                                                                                                                                         |
| [**Watcher**](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher)                                                                | ✅                                                                                                                                                                              | ❌                                                                                           | Use **Kibana Alerts** instead, which provides rich integrations across use cases                                                                                                        |
| **Web crawler**                                                                                                                                | ❌ (Managed Elastic Crawler discontinued with Enterprise Search in 9.0)                                                                                                         | Self-managed only                                                                           | Use [**self-managed crawler**](https://github.com/elastic/crawler)                                                                                                                      |

^1^  In Serverless, Elastic ensures data durability by storing indexed data in an [object store](https://www.elastic.co/blog/elastic-serverless-architecture) rather than local replicas. Writes are batched over a 200ms window to ensure durability while optimizing performance and cost, which means that single-document indexing can appear slower than in Elastic Cloud Hosted. However, this design makes Serverless more scalable and resilient to high indexing loads without relying on in-cluster replication for fault tolerance. Because of a higher baseline write latency, Serverless indexing can be scaled by increasing concurrent indexing clients.

### Observability

This table compares Observability capabilities between Elastic Cloud Hosted deployments and Observability Complete Serverless projects. For more information on Observability Logs Essentials Serverless projects, refer to [Observability feature tiers](https://www.elastic.co/docs/solutions/observability/observability-serverless-feature-tiers).

| **Feature**                                                                                                                                                | Elastic Cloud Hosted   | Serverless Observability Complete projects | Serverless notes                                                                                                                                                                              |
|------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|--------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [**AI Assistant**](https://www.elastic.co/docs/solutions/observability/ai/observability-ai-assistant)                                                      | ✅                      | ✅                                          |                                                                                                                                                                                               |
| **APM integration**                                                                                                                                        | ✅                      | ✅                                          | Use **Managed Intake Service** (supports Elastic APM and OTLP protocols)  Refer to [Managed OTLP endpoint](https://www.elastic.co/docs/reference/opentelemetry/motlp) for OTLP data ingestion |
| [**APM Agent Central Configuration**](https://www.elastic.co/docs/solutions/observability/apm/apm-server/apm-agent-central-configuration)                  | ✅                      | ❌                                          | Not available in Serverless                                                                                                                                                                   |
| [**APM Tail-based sampling**](/docs/solutions/observability/apm/transaction-sampling#apm-tail-based-sampling)                                              | ✅                      | ❌                                          | - Not available in Serverless - Consider **OpenTelemetry** tail sampling processor as an alternative                                                                                          |
| [**Android agent/SDK instrumentation**](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android)                                             | ✅                      | ✅                                          |                                                                                                                                                                                               |
| [**AWS Firehose integration**](https://www.elastic.co/docs/solutions/observability/cloud/monitor-amazon-web-services-aws-with-amazon-data-firehose)        | ✅                      | ✅                                          |                                                                                                                                                                                               |
| [**Custom roles for Kibana Spaces**](/docs/deploy-manage/manage-spaces#spaces-control-user-access)                                                         | ✅                      | ✅                                          |                                                                                                                                                                                               |
| [**Data stream lifecycle**](https://www.elastic.co/docs/manage-data/lifecycle/data-stream)                                                                 | ✅                      | ✅                                          | Primary lifecycle management method in Serverless                                                                                                                                             |
| [**EDOT Central Configuration**](https://www.elastic.co/docs/reference/opentelemetry/central-configuration)                                                | ✅                      | ❌                                          |                                                                                                                                                                                               |
| [**EDOT Cloud Forwarder**](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder)                                                       | ✅                      | ✅                                          |                                                                                                                                                                                               |
| [**EDOT Tail-based sampling**](https://www.elastic.co/docs/reference/edot-collector/config/tail-based-sampling)                                            | ✅                      | ✅                                          |                                                                                                                                                                                               |
| **[Elastic Serverless Forwarder](https://www.elastic.co/docs/reference/aws-forwarder)**                                                                    | ✅                      | ❌                                          |                                                                                                                                                                                               |
| **[Elastic Synthetics Private Locations](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-add)** | ✅                      | ✅                                          |                                                                                                                                                                                               |
| **[Fleet Agent policies](https://www.elastic.co/docs/reference/fleet/agent-policy)**                                                                       | ✅                      | ✅                                          |                                                                                                                                                                                               |
| **[Fleet server](https://www.elastic.co/docs/reference/fleet/fleet-server)**                                                                               | - Self-hosted - Hosted | ✅                                          | Fully managed by Elastic                                                                                                                                                                      |
| [**Index lifecycle management**](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management)                                             | ✅                      | ❌                                          | Use [**Data stream lifecycle**](https://www.elastic.co/docs/manage-data/lifecycle/data-stream) instead                                                                                        |
| **[iOS agent/SDK instrumentation](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios)**                                                     | ✅                      | ✅                                          |                                                                                                                                                                                               |
| **[Kibana Alerts](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts)**                                   | ✅                      | ✅                                          |                                                                                                                                                                                               |
| **[LogsDB index mode](https://www.elastic.co/docs/manage-data/data-store/data-streams/logs-data-stream)**                                                  | ✅                      | ✅                                          | - Reduces storage footprint  - Enabled by default - Cannot be disabled                                                                                                                        |
| **[Logs management](https://www.elastic.co/docs/solutions/observability/logs)**                                                                            | ✅                      | ✅                                          |                                                                                                                                                                                               |
| **[Managed OTLP Endpoint](https://www.elastic.co/docs/reference/motlp)**                                                                                   | ✅                      | ✅                                          |                                                                                                                                                                                               |
| **[Metrics monitoring](https://www.elastic.co/docs/solutions/observability/apm/metrics)**                                                                  | ✅                      | ✅                                          |                                                                                                                                                                                               |
| **[Observability SLO](https://www.elastic.co/docs/solutions/observability/incident-management/service-level-objectives-slos)**                             | ✅                      | ✅                                          |                                                                                                                                                                                               |
| [**Real User Monitoring (RUM)**](https://www.elastic.co/docs/solutions/observability/applications/user-experience)                                         | ✅                      | **Planned**                                | Anticipated in a future release                                                                                                                                                               |
| **[Universal Profiling](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/get-started-with-universal-profiling)**                        | ✅                      | ❌                                          | Not available in Serverless                                                                                                                                                                   |
| **Uptime monitoring**                                                                                                                                      | ❌                      | ❌                                          | - Deprecated in all deployment types - Use [**Synthetics app**](https://www.elastic.co/docs/solutions/observability/synthetics) instead                                                       |


### Security

This table compares Security capabilities between Elastic Cloud Hosted deployments and Serverless projects:

| **Feature**                                                                                                                | Elastic Cloud Hosted  | Serverless Security projects | Serverless notes                                                                                                                                                                                                                |
|----------------------------------------------------------------------------------------------------------------------------|-----------------------|------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **[Advanced Entity Analytics](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics)**                  | ✅                     | ✅                            |                                                                                                                                                                                                                                 |
| **[AI Assistant](https://www.elastic.co/docs/solutions/security/ai/ai-assistant)**                                         | ✅                     | ✅                            |                                                                                                                                                                                                                                 |
| **[API keys](https://www.elastic.co/docs/deploy-manage/api-keys)**                                                         | ✅                     | ✅                            |                                                                                                                                                                                                                                 |
| **[Cloud Security](https://www.elastic.co/docs/solutions/security/cloud)**                                                 | ✅                     | ✅                            |                                                                                                                                                                                                                                 |
| [**Defend for Containers integration**](https://www.elastic.co/guide/en/security/8.18/d4c-overview.html)                   | ✅ (deprecated in 9.0) | ❌                            | Not available in Serverless                                                                                                                                                                                                     |
| **[Endpoint security](https://www.elastic.co/docs/solutions/security/configure-elastic-defend)**                           | ✅                     | ✅                            |                                                                                                                                                                                                                                 |
| **[Kibana Alerts](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts)**   | ✅                     | ✅                            |                                                                                                                                                                                                                                 |
| **Kibana navigation**                                                                                                      | Standard layout       | Different layout             | UI differences in Security projects                                                                                                                                                                                             |
| **[LogsDB](https://www.elastic.co/docs/manage-data/data-store/data-streams/logs-data-stream)**                             | Optional              | ✅                            | - Enabled by default - Cannot be disabled                                                                                                                                                                                       |
| **[Native realm authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native)** | ✅                     | ❌                            | Only API key-based authentication is supported at the project level. User authentication, including SAML SSO, is managed at the [organization level](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization). |
| **Role-based access control**                                                                                              | ✅                     | Limited                      | Core RBAC functionality supported                                                                                                                                                                                               |
| **SIEM capabilities**                                                                                                      | ✅                     | ✅                            | Core functionality supported                                                                                                                                                                                                    |


## Elasticsearch index sizing guidelines

To ensure optimal performance in Serverless Elasticsearch projects, follow these sizing recommendations:

| **Use case**                         | Maximum index size | Project configuration |
|--------------------------------------|--------------------|-----------------------|
| **Vector search**                    | 150GB              | Vector optimized      |
| **General search (non data-stream)** | 300GB              | General purpose       |
| **Other uses (non data-stream)**     | 600GB              | General purpose       |

If you expect that you will have large datasets that exceed the recommended maximum size, consider creating multiple smaller indices that you can query using an [alias](https://www.elastic.co/docs/manage-data/data-store/aliases), or configuring [data stream lifecycle](https://www.elastic.co/docs/manage-data/lifecycle/data-stream) to prevent data streams from growing larger than the maximum size. You should design your indexing and data lifecycle strategy with the size and growth of your data in mind.
These recommendations do not apply to indices using better binary quantization (BBQ). Refer to [vector quantization](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/dense-vector#dense-vector-quantization) for more information.

## Available Elasticsearch APIs

In Elastic Cloud Serverless, access is limited to a subset of Elasticsearch APIs, as Elastic manages the underlying infrastructure. These restrictions help maintain cluster stability, availability, and data integrity, ensuring reliable operation of Serverless projects.
The following Elasticsearch APIs are not available in Elastic Cloud Serverless:
<definitions>
  <definition term="Infrastructure operations">
    - All `_nodes/*` operations
    - All `_cluster/*` operations
    - Most `_cat/*` operations, except for index-related operations such as `/_cat/indices` and `/_cat/aliases`
  </definition>
  <definition term="Storage and backup">
    - All `_snapshot/*` operations
    - Repository management operations
  </definition>
  <definition term="Index management">
    - `indices/close` operations
    - `indices/open` operations
    - Recovery and stats operations
    - Force merge operations
  </definition>
</definitions>

When attempting to use an unavailable API, you'll receive this error:
```json
{
 "error": {
   "root_cause": [
     {
       "type": "api_not_available_exception",
       "reason": "Request for uri [/<API_ENDPOINT>] with method [<METHOD>] exists but is not available when running in serverless mode"
     }
   ],
   "status": 410
 }
}
```

<tip>
  Refer to the [Elasticsearch Serverless API reference](https://www.elastic.co/docs/api/doc/elasticsearch-serverless) for a complete list of available APIs.
</tip>


## Available Elasticsearch settings

In Elastic Cloud Serverless projects, configuration available to users is limited to certain [index-level settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings), while Elastic manages cluster-level and node-level settings to maintain stability, availability, performance, and data integrity. These restrictions help ensure the reliability of Serverless projects.
<definitions>
  <definition term="Available settings">
    **Index-level settings**: Settings that control how documents are processed, stored, and searched are available to end users. These include:
    - Analysis configuration
    - Mapping parameters
    - Search/query settings
    - Indexing settings such as `refresh_interval`
  </definition>
</definitions>

Some settings might have different default values or value constraints in Serverless. This information is documented in the [settings reference](https://www.elastic.co/docs/reference/elasticsearch/index-settings).
<definitions>
  <definition term="Managed settings">
    **Infrastructure-related settings**: Settings that affect cluster resources or data distribution are not available to end users. These include:
    - Node configurations
    - Cluster topology
    - Shard allocation
    - Resource management
  </definition>
</definitions>

When attempting to use an unavailable index setting, you'll receive this error:
```json
{
    "error": {
        "root_cause": [
            {
                "type": "illegal_argument_exception",
                "reason": "Settings [xyz] are not available when running in serverless mode"
            }
        ],
        "type": "illegal_argument_exception",
        "reason": "Settings [xyz] are not available when running in serverless mode"
    },
    "status": 400
}
```


## Learn more

- [Elastic Cloud Serverless roadmap](https://www.elastic.co/cloud/serverless/roadmap): See upcoming features and development plans for the Serverless platform
- [Elasticsearch Serverless API reference](https://www.elastic.co/docs/api/doc/elasticsearch-serverless): Check out the complete list of available APIs in Elastic Cloud Serverless
- [Project settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings): Configure project settings in Elastic Cloud Serverless
- [Serverless regions](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/regions): Choose the right region for your Elastic Cloud Serverless project
- [Elastic Cloud pricing](https://www.elastic.co/pricing/): Understand pricing for Elastic Cloud Hosted and Serverless projects
  - [Serverless project billing](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/serverless-project-billing-dimensions): Understand billing dimensions for Serverless projects
- [Elastic Cloud Hosted billing](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/cloud-hosted-deployment-billing-dimensions): Understand billing dimensions for Elastic Cloud Hosted deployments