﻿---
title: Configure custom endpoint aliases on Elastic Cloud Hosted
description: Custom aliases for your deployment endpoints on Elastic Cloud Hosted allow you to have predictable, human-readable URLs that can be shared easily. An...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/custom-endpoint-aliases
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Configure custom endpoint aliases on Elastic Cloud Hosted
Custom aliases for your deployment endpoints on Elastic Cloud Hosted allow you to have predictable, human-readable URLs that can be shared easily. An alias is unique to only one deployment within a region.

## Create a custom endpoint alias for a deployment

<note>
  New deployments are assigned a default alias derived from the deployment name. This alias can be modified later, if needed.
</note>

To add an alias to an existing deployment:
1. From the **Hosted deployments** menu, select a deployment.
2. Under **Connection alias**, select **Create an alias**.
3. Define a new alias. Make sure you choose something meaningful to you.
   <tip>
   Make the alias as unique as possible to avoid collisions. Aliases might have been already claimed by other users for deployments in the region.
   </tip>
4. Select **Update alias**.


## Remove a custom endpoint alias

To remove an alias from your deployment, or if you want to re-assign an alias to another deployment, follow these steps:
1. From the **Hosted deployments** menu, select a deployment.
2. Under **Connection alias**, select **Edit**.
3. Remove the text from the **Connection alias** text box.
4. Select **Update alias**.

<note>
  After removing an alias, your organisation’s account will hold a claim on it for 30 days. After that period, other users can re-use this alias.
</note>


## Using the custom endpoint URL

To use your new custom endpoint URL to access your Elastic products, note that each has its own alias to use in place of the default application UUID. For example, if you configured the custom endpoint alias for your deployment to be `test-alias`, the corresponding alias for the Elasticsearch cluster in that deployment is `test-alias.es`.
<note>
  You can get the application-specific custom endpoint alias by selecting **Copy endpoint** for that product. It should contain a subdomain for each application type, for example `es`, `kb`, `apm`, or `ent`.
</note>


### With the REST Client

- As part of the host name:
  After configuring your custom endpoint alias, select **Copy endpoint** on the deployment overview page, which gives you the fully qualified custom endpoint URL for that product.
- As an HTTP request header:
  Alternatively, you can reach your application by passing the application-specific custom endpoint alias, for example, `test-alias.es`, as the value for the `X-Found-Cluster` HTTP header.


### With the `TransportClient`

While the `TransportClient` is deprecated, your custom endpoint aliases still work with it. Similar to the REST Client, there are two ways to use your custom endpoint alias with the `TransportClient`:
- As part of the host name:
  Similar to HTTP, you can find the fully qualified host on the deployment overview page by selecting **Copy endpoint** next to Elasticsearch. Make sure to remove the unnecessary `https://` prefix as well as the trailing HTTP port.
- As part of the **Settings**:
  Include the application-specific custom endpoint alias as the value for `request.headers.X-Found-Cluster` setting in place of the `clusterId`:
  ```java
  // Build the settings for our client.
  String alias = "test-alias.es";
  String region = "us-east-1";
  boolean enableSsl = true;

  Settings settings = Settings.settingsBuilder()
      .put("transport.ping_schedule", "5s")
      //.put("transport.sniff", false)
      .put("action.bulk.compress", false)
      .put("shield.transport.ssl", enableSsl)
      .put("request.headers.X-Found-Cluster", alias)
      .put("shield.user", "username:password")
      .build();

  String hostname = alias + "." + region + ".aws.found.io";
  // Instantiate a TransportClient and add the cluster to the list of addresses to connect to.
  // Only port 9343 (SSL-encrypted) is currently supported.
  Client client = TransportClient.builder()
          .addPlugin(ShieldPlugin.class)
          .settings(settings)
          .build()
          .addTransportAddress(new InetSocketTransportAddress(InetAddress.getByName(hostname), 9343));
  ```

For more information on configuring the `TransportClient`, see

## Create a custom domain with NGINX

If you don’t get the level of domain customization you’re looking for by using the [custom endpoint aliases](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/custom-endpoint-aliases), you might consider creating a CNAME record that points to your Elastic Cloud endpoints. However, that can lead to some issues. Instead, setting up your own proxy could provide the desired level of customization.
<important>
  The setup described in the following sections is not supported by Elastic, and if your proxy cannot connect to the endpoint, but curl can, we may not be able to help.
</important>


### Avoid creating CNAMEs

To achieve a fully custom domain, you can add a CNAME that points to your Elastic Cloud endpoint. However, this will lead to invalid certificate errors, and moreover, may simply not work. Your Elastic Cloud endpoints already point to a proxy internal to Elastic Cloud, which may not resolve your configured CNAME in the desired way.
So what to do, instead?

### Setting up a proxy

Here we’ll show you an example of proxying with NGINX, but this can be extrapolated to HAProxy or some other proxy server.
You need to set `proxy_pass` and `proxy_set_header`, and include the `X-Found-Cluster` header with the cluster’s UUID. You can get the cluster ID by clicking the `Copy cluster ID` link on your deployment’s main page.
```
server {
    listen 443 ssl;
    server_name elasticsearch.example.com;

    include /etc/nginx/tls.conf;

    location / {
        proxy_pass        https://<UUID>.eu-west-1.aws.elastic-cloud.com/;
        proxy_set_header  X-Found-Cluster <UUID>;
    }
}
```

This should work for all of your applications, not just Elasticsearch. To set it up for Kibana, for example, you can select `Copy cluster ID` next to Kibana on your deployment’s main page to get the correct UUID.
<note>
  Doing this for Kibana won't work with Cloud SSO.
</note>

To configure `tls.conf in this example, check out [[https://ssl-config.mozilla.org/](https://ssl-config.mozilla.org/)](https://ssl-config.mozilla.org/) for more fields.