﻿---
title: Create a serverless project
description: Choose the type of project that matches your needs and we’ll help you get started with our solution guides. 
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/create-serverless-project
products:
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
---

# Create a serverless project
There are two options to create serverless projects:
- If you are a new user, [sign up for a free 14-day trial](https://cloud.elastic.co/serverless-registration) to create a serverless project. For more information about the Elastic Cloud trials, check [Trial features](/docs/deploy-manage/deploy/elastic-cloud/create-an-organization#general-sign-up-trial-what-is-included-in-my-trial).
- If you are an existing customer, [log in to Elastic Cloud](https://cloud.elastic.co/login). On the home page, you will see a new option to create serverless projects. The `admin` predefined role or an equivalent custom role is required to create projects. Refer to [User roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles).

Choose the type of project that matches your needs and we’ll help you get started with our solution guides.

|                                                                                                                                  |                                                                                                                                                                       |
|----------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|                                                                                                                                  |                                                                                                                                                                       |
| ![elasticsearch](https://www.elastic.co/docs/deploy-manage/images/64x64_Color_elasticsearch-logo-color-64px.png "elasticsearch") | **Elasticsearch** Build custom search-powered applications with Elasticsearch.[**View guide →**](https://www.elastic.co/docs/solutions/search/get-started)            |
| ![observability](https://www.elastic.co/docs/deploy-manage/images/64x64_Color_observability-logo-color-64px.png "observability") | **Observability** Monitor applications and systems with Elastic Observability.[**View guide →**](https://www.elastic.co/docs/solutions/observability/get-started)     |
| ![security](https://www.elastic.co/docs/deploy-manage/images/64x64_Color_security-logo-color-64px.png "security")                | **Security** Detect, investigate, and respond to threats with Elastic Security.[**View guide →**](/docs/solutions/security/get-started#create-sec-serverless-project) |
|                                                                                                                                  |                                                                                                                                                                       |