﻿---
title: Sign up and create an organization
description: To sign up: Go to the Elastic Cloud Sign Up page.Choose one of the available sign up methods. You can register with your email address and a password,...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/create-an-organization
products:
  - Elastic Cloud Hosted
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Sign up and create an organization
To sign up:
1. Go to the [Elastic Cloud Sign Up](https://cloud.elastic.co/registration?page=docs&placement=docs-body) page.
2. Choose one of the available sign up methods. You can register with your email address and a password, use a Google or Microsoft account, or [subscribe from a Marketplace](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/subscribe-from-marketplace).

<note>
  - You can only belong to one Elastic Cloud organization at a time. If you want to create or join another organization, you must [leave the previous one](/docs/cloud-account/join-or-leave-an-organization#ec-leave-organization) or use a different email address.
  - An email address can’t be used for more than one Elastic Cloud account. To make the email address available for a new account, you can [remove it from your existing account](/docs/cloud-account/update-your-email-address#sign-up-existing).
</note>

When you first sign up, you create an organization and start with a trial license.
This organization is the umbrella for all of your Elastic Cloud resources, users, and account settings. Every organization has a unique identifier. Bills are invoiced according to the billing contact and details that you set for your organization. For more details on how to manage your organization, refer to [Manage your Cloud organization](https://www.elastic.co/docs/deploy-manage/cloud-organization).

## Trial information

Your free 14-day trial includes:
**One hosted deployment**
A deployment lets you explore Elastic solutions for Search, Observability, and Security. Trial deployments run on the latest version of the Elastic Stack. They includes 8 GB of RAM spread out over two availability zones, and enough storage space to get you started. If you’re looking to evaluate a smaller workload, you can scale down your trial deployment. Each deployment includes Elastic features such as Maps, SIEM, machine learning, advanced security, and much more. You have some sample data sets to play with and tutorials that describe how to add your own data.
For more information, check the [Elastic Cloud Hosted documentation](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/cloud-hosted).
**Three Serverless projects**
Serverless projects package Elastic Stack features by type of solution:
- [Elasticsearch](https://www.elastic.co/docs/solutions/search)
- [Observability](https://www.elastic.co/docs/solutions/observability)
- [Security](https://www.elastic.co/docs/solutions/security)

When you create a project, you select the project type applicable to your use case, so only the relevant and impactful applications and features are easily accessible to you.
For more information, check the [Serverless documentation](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless).

### Trial limitations

During the free 14-day trial, Elastic provides access to one hosted deployment and three Serverless projects. If all you want to do is try out Elastic, the trial includes more than enough to get you started. During the trial period, some limitations apply.
**Hosted deployments**
- You can only have one active deployment at a time.
- The deployment size is limited to 8GB RAM and approximately 360GB of storage, depending on the specified hardware profile.
- Machine learning nodes are available up to 4GB RAM, or up to 8GB when using Reranker.
- Custom Elasticsearch plugins are not enabled.
- We monitor token usage per account for the Elastic Managed LLMs. If an account uses over one million tokens in 24 hours, we will inform you, then remove access to the LLM. This is in accordance with our fair use policy for trials.

**Serverless projects**
- You can have three active Serverless projects at a time.
- Search Power is limited to 100 and Search Boost Window is limited to 7 days. These [settings](/docs/deploy-manage/deploy/elastic-cloud/project-settings#elasticsearch-manage-project-search-ai-lake-settings) apply only to Elasticsearch Serverless projects.
- Scaling is limited for Serverless projects in trials. Failures might occur if the workload requires memory or compute beyond what the above search power and search boost window setting limits can provide.
- We monitor token usage per account for Elastic Managed LLMs. If an account uses over one million tokens in 24 hours, we will inform, then remove access to the LLM. This is in accordance with our fair use policy for trials.


### Get started with your trial

Start by checking out some common approaches for [moving data into Elastic Cloud](https://www.elastic.co/docs/manage-data/ingest).

### Remove trial limitations

Subscribe to [Elastic Cloud](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/add-billing-details) for the following benefits:
- Increased memory or storage for deployment components, such as Elasticsearch clusters, machine learning nodes, and APM server.
- As many deployments and projects as you need.
- Third availability zone for your deployments.
- Access to additional features, such as cross-cluster search and cross-cluster replication.

You can subscribe to Elastic Cloud at any time during your trial.
[Billing](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/serverless-project-billing-dimensions) starts when you subscribe.
To maximize the benefits of your trial, subscribe at the end of the free period.
To monitor charges, anticipate future costs, and adjust your usage, check your [account usage](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/monitor-analyze-usage) and [billing history](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/view-billing-history).

### Maintain access to your trial projects and data

When your trial expires, the deployment and projects that you created during the trial period are suspended until you subscribe to [Elastic Cloud](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/add-billing-details). When you subscribe, you are able to resume your deployment and Serverless projects, and regain access to the ingested data. After your trial expires, you have 30 days to subscribe. After 30 days, your deployment, Serverless projects, and ingested data are permanently deleted.
If you’re interested in learning more ways to subscribe to Elastic Cloud, don’t hesitate to [contact us](https://www.elastic.co/contact).

## How do I get help?

We’re here to help. If you have any questions feel free to reach out to [Support](https://cloud.elastic.co/support).