﻿---
title: Elastic Cloud Hosted
description: Elastic Cloud Hosted is the Elastic Stack, managed through Elastic Cloud deployments. It is also formerly known as Elasticsearch Service. Elastic Cloud...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/cloud-hosted
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Elastic Cloud Hosted
**Elastic Cloud Hosted is the Elastic Stack, managed through Elastic Cloud deployments.**
It is also formerly known as Elasticsearch Service.
Elastic Cloud Hosted allows you to manage one or more instances of the Elastic Stack through **deployments**. These deployments are hosted on Elastic Cloud, through the cloud provider and regions of your choice, and are tied to your organization account.
A **hosted deployment** helps you manage an Elasticsearch cluster and instances of other Elastic products, like Kibana or APM instances, in one place. Spin up, scale, upgrade, and delete your Elastic Stack products without having to manage each one separately. In a deployment, everything works together.
<note>
  Elastic Cloud Hosted is one of the two deployment options available on Elastic Cloud. [Depending on your needs](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud), you can also run [Elastic Cloud Serverless projects](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless).
</note>

**Hardware profiles to optimize deployments for your usage.**
You can optimize the configuration and performance of a deployment by selecting a **hardware profile** that matches your usage.
*Hardware profiles* are presets that provide a unique blend of storage, memory and vCPU for each component of a deployment. They support a specific purpose, such as a hot-warm architecture that helps you manage your data storage retention.
You can use these presets, or start from them to get the unique configuration you need. They can vary slightly from one cloud provider or region to another to align with the available virtual hardware.
**Solutions to help you make the most out of your data in each deployment.**
Building a rich search experience, gaining actionable insight into your environment, or protecting your systems and endpoints? You can implement each of these major use cases, and more, with the solutions that are pre-built in each Elastic deployment.
![Elastic Stack components and solutions with Enterprise Search](https://www.elastic.co/docs/deploy-manage/images/cloud-ec-stack-components.png)

<important>
  Enterprise Search is not available in Elastic Stack 9.0+.
</important>

These solutions help you accomplish your use cases: Ingest data into the deployment and set up specific capabilities of the Elastic Stack.
Of course, you can choose to follow your own path and use Elastic components available in your deployment to ingest, visualize, and analyze your data independently from solutions.

## How to operate Elastic Cloud Hosted

**Where to start?**
- Learn the basics of Elasticsearch, the Elastic Stack, and its solutions in [Get started](https://www.elastic.co/docs/get-started).
- Sign up using your preferred method:
  - [Sign Up for a Trial](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/create-an-organization) - Sign up, check what your free trial includes and when we require a credit card.
- [Sign Up from Marketplace](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/subscribe-from-marketplace) - Consolidate billing portals by signing up through one of the available marketplaces.
- [Create a deployment](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/create-an-elastic-cloud-hosted-deployment) - Get up and running very quickly. Select your desired configuration and let Elastic deploy Elasticsearch, Kibana, and the Elastic products that you need for you. In a deployment, everything works together, everything runs on hardware that is optimized for your use case.
- [Connect your data to your deployment](https://www.elastic.co/docs/manage-data/ingest) - Ingest and index the data you want, from a variety of sources, and take action on it.

**Adjust the capacity and capabilities of your deployments for production**
There are a few things that can help you make sure that your production deployments remain available, healthy, and ready to handle your data in a scalable way over time, with the expected level of performance. Check [Production guidance](https://www.elastic.co/docs/deploy-manage/production-guidance).
**Secure your environment**
Elastic Cloud has built-in security. For example, HTTPS communications between Elastic Cloud and the internet, as well as inter-node communications, are secured automatically, and cluster data is encrypted at rest.
In both Elastic Cloud Hosted and Elastic Cloud Serverless, you can also configure [IP filters](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-cloud) to prevent unauthorized access to your deployments and projects.
In Elastic Cloud Hosted, you can augment these security features in the following ways:
- [Configure private connectivity and apply VPC filtering](https://www.elastic.co/docs/deploy-manage/security/private-connectivity) to establish a secure connection for your Elastic Cloud deployments to communicate with other cloud services, and restrict traffic to deployments based on those private connections.
- Encrypt your deployment with a [customer-managed encryption key](https://www.elastic.co/docs/deploy-manage/security/encrypt-deployment-with-customer-managed-encryption-key).
- [Secure your settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings) using Elasticsearch and Kibana keystores.
- Use the list of [Elastic Cloud static IPs](https://www.elastic.co/docs/deploy-manage/security/elastic-cloud-static-ips) to allow or restrict communications in your infrastructure.

Elastic Cloud Hosted doesn't support custom SSL certificates, which means that a custom CNAME for an Elastic Cloud Hosted endpoint such as *mycluster.mycompanyname.com* also is not supported.
Refer to [Elastic Cloud security](https://www.elastic.co/cloud/security) for more details about Elastic security and privacy programs.
Refer to [Security](https://www.elastic.co/docs/deploy-manage/security) for more details.
<note>
  As part of your overall security strategy, you can also do the following:
  - Prevent unauthorized access with [password protection and role-based access control](https://www.elastic.co/docs/deploy-manage/users-roles).
  - Control access to dashboards and other saved objects in your UI using [Spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces).
  - Connect a local cluster to a [remote cluster](https://www.elastic.co/docs/deploy-manage/remote-clusters) to enable [cross-cluster replication](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication) and [cross-cluster search](https://www.elastic.co/docs/explore-analyze/cross-cluster-search).
  - Manage [API keys](https://www.elastic.co/docs/deploy-manage/api-keys) used for programmatic access to Elastic.
</note>

**Monitor your deployments and keep them healthy**
Elastic Cloud Hosted provides several ways to monitor your deployments, anticipate and prevent issues, or fix them when they occur. Check [Monitoring](https://www.elastic.co/docs/deploy-manage/monitor) to get more details.
<admonition title="Simplify monitoring with AutoOps">
  AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths. Learn more about [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops).
</admonition>


## More about Elastic Cloud Hosted

Find more information about Elastic Cloud Hosted on the following pages:
- [Licenses and subscriptions](https://www.elastic.co/docs/deploy-manage/license)
- [Available stack versions](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/available-stack-versions)
- [Elastic Cloud Hosted hardware](https://www.elastic.co/docs/reference/cloud/cloud-hosted/hardware)
- [Elastic Cloud Hosted regions](https://www.elastic.co/docs/reference/cloud/cloud-hosted/regions)
- [Service status](https://www.elastic.co/docs/deploy-manage/cloud-organization/service-status)
- [Getting help](https://www.elastic.co/docs/troubleshoot)
- [Restrictions and known problems](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/restrictions-known-problems)

<dropdown title="Elastic Cloud Hosted FAQ">
  This frequently-asked-questions list helps you with common questions while you get Elastic Cloud Hosted up and running for the first time. For questions about Elastic Cloud Hosted configuration options or billing, check the [Technical FAQ](https://www.elastic.co/docs/deploy-manage) and the [Billing FAQ](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/billing-faq).
  - [What is Elastic Cloud Hosted?](#faq-what)
  - [Is Elastic Cloud Hosted, formerly known as Elasticsearch Service, the same as Amazon’s Elasticsearch Service?](#faq-aws-difference)
  - [Can I run the full Elastic Stack in Elastic Cloud Hosted?](#faq-full-stack)
  - [Can I try Elastic Cloud Hosted for free?](#faq-trial)
  - [What if I need to change the size of my Elasticsearch cluster at a later time?](#faq-config)
  - [Do you offer support subscriptions?](#faq-subscriptions)
  - [Where are deployments hosted?](#faq-where)
  - [What is the difference between Elastic Cloud Hosted and the Amazon Elasticsearch Service?](#faq-vs-aws)
  - [Can I use Elastic Cloud Hosted on platforms other than AWS?](#faq-aws)
  - [Do you offer Elastic’s commercial products?](#faq-elastic)
  - [Is there a limit on the number of documents or indexes I can have in my cluster?](#faq-limit)

  <definitions>
    <definition term="What is Elastic Cloud Hosted?">
      Elastic Cloud Hosted is hosted and managed Elasticsearch and Kibana brought to you by the creators of Elasticsearch. Elastic Cloud Hosted is part of Elastic Cloud and ships with features that you can only get from the company behind Elasticsearch, Kibana, Beats, and Logstash. Elasticsearch is a full text search engine that suits a range of uses, from search on websites to big data analytics and more.
    </definition>
    <definition term="Is Elastic Cloud Hosted, formerly known as Elasticsearch Service, the same as Amazon’s Elasticsearch Service?">
      Elastic Cloud Hosted is not the same as the Amazon Elasticsearch service. To learn more about the differences, check our [AWS Elasticsearch Service](https://www.elastic.co/aws-elasticsearch-service) comparison.
    </definition>
    <definition term="Can I run the full Elastic Stack in Elastic Cloud Hosted?">
      Many of the products that are part of the Elastic Stack are readily available in Elastic Cloud Hosted, including Elasticsearch, Kibana, plugins, and features such as monitoring and security. Use other Elastic Stack products directly with Elastic Cloud Hosted. For example, both Logstash and Beats can send their data to Elastic Cloud Hosted. What is run is determined by the [subscription level](https://www.elastic.co/cloud/as-a-service/subscriptions).
    </definition>
    <definition term="Can I try Elastic Cloud Hosted for free?">
      Yes, sign up for a 14-day free trial. The trial starts the moment a cluster is created. During the free trial period get access to a deployment to explore Elastic solutions for Search, Observability, Security, or the latest version of the Elastic Stack.
    </definition>
    <definition term="What if I need to change the size of my Elasticsearch cluster at a later time?">
      Scale your clusters both up and down from the user console, whenever you like. The resizing of the cluster is transparently done in the background, and highly available clusters are resized without any downtime. If you scale your cluster down, make sure that the downsized cluster can handle your Elasticsearch memory requirements. Read more about sizing and memory in [Sizing Elasticsearch](https://www.elastic.co/blog/found-sizing-elasticsearch).
    </definition>
    <definition term="Do you offer support?">
      Yes, all subscription levels for Elastic Cloud Hosted include support, handled by email or through the Elastic Support Portal. Different subscription levels include different levels of support. For the Standard subscription level, there is no service-level agreement (SLA) on support response times. Gold and Platinum subscription levels include an SLA on response times to tickets and dedicated resources. To learn more, check [Getting Help](https://www.elastic.co/docs/troubleshoot).
    </definition>
    <definition term="Where are deployments hosted?">
      We host our Elasticsearch clusters on Amazon Web Services (AWS), Google Cloud Platform (GCP), and Microsoft Azure. Check out which [regions we support](https://www.elastic.co/docs/reference/cloud/cloud-hosted/regions) and what [hardware we use](https://www.elastic.co/docs/reference/cloud/cloud-hosted/hardware). New data centers are added all the time.
    </definition>
    <definition term="What is the difference between Elastic Cloud Hosted and the Amazon Elasticsearch Service?">
      Elastic Cloud Hosted is the only hosted and managed Elasticsearch service built, managed, and supported by the company behind Elasticsearch, Kibana, Beats, and Logstash. With Elastic Cloud Hosted, you always get the latest versions of the software. Our service is built on best practices and years of experience hosting and managing thousands of Elasticsearch clusters in the Cloud and on premise. For more information, check the following Amazon and Elastic Elasticsearch Service [comparison page](https://www.elastic.co/aws-elasticsearch-service).
      Note that there is no formal partnership between Elastic and Amazon Web Services (AWS), and Elastic does not provide any support on the AWS Elasticsearch Service.
    </definition>
    <definition term="Can I use Elastic Cloud Hosted on platforms other than AWS?">
      Yes, create deployments on the Google Cloud Platform and Microsoft Azure.
    </definition>
    <definition term="Do you offer Elastic’s commercial products?">
      Yes, all Elastic Cloud Hosted customers have access to basic authentication, role-based access control, and monitoring.
      Elastic Cloud Gold, Platinum and Enterprise customers get complete access to all the capabilities in X-Pack:
      - Security
      - Alerting
      - Monitoring
      - Reporting
      - Graph Analysis & Visualization
      [Contact us](https://www.elastic.co/cloud/contact) to learn more.
    </definition>
    <definition term="Is there a limit on the number of documents or indexes I can have in my cluster?">
      No. We do not enforce any artificial limit on the number of indexes or documents you can store in your cluster.
      That said, there is a limit to how many indexes Elasticsearch can cope with. Every shard of every index is a separate Lucene index, which in turn comprises several files. A process cannot have an unlimited number of open files. Also, every shard has its associated control structures in memory. So, while we will let you make as many indexes as you want, there are limiting factors. Our larger plans provide your processes with more dedicated memory and CPU-shares, so they are capable of handling more indexes. The number of indexes or documents you can fit in a given plan therefore depends on their structure and use.
    </definition>
  </definitions>
</dropdown>