﻿---
title: Customize instance configuration
description: This document explains how to modify the instance configurations used by specific components of your deployment without changing the overall hardware...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/change-hardware
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Customize instance configuration
This document explains how to modify the instance configurations used by specific components of your deployment without changing the overall hardware profile assigned to the deployment. This advanced configuration scenario is useful in situations where you need to migrate an Elasticsearch tier or stateless resource to a different hardware type.

## Consideration

Elastic Stack deployments run on virtual hardware defined by instance configurations. For more details, refer to [Hardware profiles](/docs/deploy-manage/deploy/elastic-cloud/ec-change-hardware-profile#ec-hardware-profile) and [Instance configurations](https://www.elastic.co/docs/reference/cloud/cloud-hosted/hardware#ec-getting-started-configurations) documents.
When a deployment is created, each Elasticsearch tier and stateless resource (e.g., Kibana) gets an instance configuration assigned to it, based on the hardware profile used. The combination of instance configurations defined within each hardware profile is designed to provide the best possible outcome for each use case. Therefore, it is not advisable to use instance configurations that are not specified on the hardware profile, except in specific situations in which we may need to migrate an Elasticsearch tier or stateless resource to a different hardware type. An example of such a scenario is when a cloud provider stops supporting a hardware type in a specific region.

## Migrate to a different instance configuration using the API

Hardware profile migrations are possible to perform through the Elastic Cloud console, however, migrating a specific tier or resource to a different instance configuration can only be achieved through the API.
Prerequisites:
- A valid Elastic Cloud [API key](https://www.elastic.co/docs/deploy-manage/api-keys/elastic-cloud-api-keys) (`$EC_API_KEY`)

Follow these steps to migrate to a different instance configuration, replacing the default `$EC_API_KEY` value with your actual API key:
1. From the  [list of instance configurations available for each region](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-regions-templates-instances), select the target instance configuration you want to migrate to.
   <note>
   The target instance configuration must be compatible with the Elasticsearch tier or stateless resource you are updating.
   For example, if you are migrating the hot Elasticsearch tier, the target instance configuration must also be of the `es.datahot` family.
   </note>
2. Get the deployment update payload from the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body) **Edit** page, by selecting **Equivalent API request**, and store it in a file called `migrate_instance_configuration.json`.
   Example payload containing relevant data for migrating the hot Elasticsearch tier:
   ```json
   {
     "resources": {
       "elasticsearch": [
         {
           "plan": {
             "cluster_topology": [
               {
                 "id": "hot_content",
                 "instance_configuration_id": "gcp.es.datahot.n2.68x10x45",
                 "instance_configuration_version": 1,
   ```
3. Set the `instance_configuration_id` field of the Elasticsearch tier or stateless resource you want to migrate to the **Instance ID** of the instance configuration selected in step 1.
4. If the `instance_configuration_version` field is defined for that Elasticsearch tier or stateless resource, remove it from the payload.
   Following is the update that would be required to migrate the example above to the `gcp.es.datahot.n2.68x10x95` instance configuration:
   ```json
   {
     "resources": {
       "elasticsearch": [
         {
           "plan": {
             "cluster_topology": [
               {
                 "id": "hot_content",
                 "instance_configuration_id": "gcp.es.datahot.n2.68x10x95",
   ```
5. Use the payload to update your deployment and perform the instance configuration migration.
   ```sh
   curl -XPUT https://api.elastic-cloud.com/api/v1/deployments/{deployment_id} \
   -H "Authorization: ApiKey $EC_API_KEY" \
   -H 'Content-Type: application/json' \
   -d @migrate_instance_configuration.json
   ```

<note>
  You can perform multiple instance configuration migrations in the same request.
</note>

<warning>
  Having an instance configuration mismatch between the deployment and the hardware profile will cause the Elastic Cloud console to announce that there is a **Newer version available** for the hardware profile. Any hardware profile migration performed through the Elastic Cloud console will cause the instance configurations to be reset to the values in the hardware profile.
</warning>


## Deprecated instance configurations (ICs) and deployment templates (DTs)

Hardware profile is also referenced as deployment templates in Elastic Cloud.
You can find a list of deprecated and valid instance configurations (ICs) and deployment templates (DTs) in two ways:

### Public documentation page

Visit the [Available regions, deployment templates and instance configurations](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-regions-templates-instances) page for detailed information.

### API access

Use the [Get deployment templates API](https://www.elastic.co/docs/api/doc/cloud/operation/operation-get-deployment-templates-v2) with query parameters like `hide_deprecated` to retrieve valid ICs and DTs. This API request returns a list of DTs along with the respective ICs referenced within each DT.
For example,
- To return valid ICs/DTs the following request can be used: `https://api.elastic-cloud.com/api/v1/deployments/templates?region=us-west-2&hide_deprecated=true`.
- To list only the deprecated ones, this can be used: `https://api.elastic-cloud.com/api/v1/deployments/templates?region=us-west-2&metadata=legacy:true`.

If a deprecated IC/DT is already in use, it can continue to be used. However, creating or migrating to a deprecated IC/DT is no longer possible and will result in a plan failing. In order to migrate to a valid IC/DT, navigate to the **Edit hardware profile** option in the Cloud UI or use the [Deployment API](https://www.elastic.co/docs/api/doc/cloud/operation/operation-migrate-deployment-template).
<note>
  Deployments using Elastic Stack versions prior to 7.10 do not support changing the hardware profile through the Elastic Cloud console or API. To change the hardware profile, first upgrade to version 7.10 or later.
</note>

In addtion, you can refer to below information about how these terminologies are referenced.
- _Deprecated_ is also referenced as _legacy_.
- Using the `metadata=legacy:true` query parameter will return only legacy/deprecated DTs.
- Using the `hide_deprecated=true` query parameter will return only valid DTs.
- Not using any of the query parameters above will return all DTs. In this case, check the presence of `legacy: true` in the `metadata` entries within the API response, to verify if an IC/DT is deprecated or not.