﻿---
title: Azure Marketplace pricing
description: The pricing in Azure Marketplace defines how on-demand usage and prepaid fees get converted from ECUs and discounts into the local currency in which you...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/azure-marketplace-pricing
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Azure Marketplace pricing
The pricing in Azure Marketplace defines how on-demand usage and prepaid fees get converted from ECUs and discounts into the local currency in which you transact on Azure Marketplace.
We will be updating the pricing plan for Elastic Cloud on Azure Marketplace effective November 1st, 2025. This update will affect customers paying in CHF, DKK, EUR, GBP, or SEK.
In the past, we had updated the pricing plan for Elastic Cloud on Azure Marketplace effective January 1st, 2024. This update had affected customers paying in non-USD currencies.

## Why we’re making these changes

The pricing plan update enables us to align with market trends and adapt to changing economic conditions, ensuring that we continue delivering the highest standard of service.

## Who is affected in November 2025

These price changes will apply to customers who are currently paying for Azure Marketplace services in CHF, DKK, EUR, GBP, SEK, or TWD. If you are paying in USD or any other currency, your pricing and billing will remain unchanged.
Note that if you are using a private plan, your price is not affected.

| Currency | Price | Elastic Billing Units for Azure† |
|----------|-------|----------------------------------|
| CHF      | 0.9   | CHF 0.09 per 1000 units          |
| DKK      | 7.1   | 0.74 kr. per 1000 units          |
| EUR      | 0.9   | €0.09 per 1000 units             |
| GBP      | 0.8   | £0.08 per 1000 units             |
| SEK      | 10.6  | 1,06 kr. per 1000 units          |
| TWD      | 32.7  | NT$3.27 per 1000 units           |


## Who was affected in January 2024

These pricing changes have applied to customers who were currently paying for Azure Marketplace services in non-USD currencies. If you are paying in USD, your pricing and billing will remain unchanged.

| Currency | Price   | Elastic Billing Units for Azure† |
|----------|---------|----------------------------------|
| USD      | 1.00    | $0.10 per 1000 units             |
| AUD      | 1.60    | $0.16 per 1000 units             |
| BRL      | 5.40    | R$0.54 per 1000 units            |
| CAD      | 1.50    | $0.15 per 1000 units             |
| CHF      | 1.00    | CHF 0.10 per 1000 units          |
| DKK      | 7.40    | 0,74 kr. per 1000 units          |
| EUR      | 1.00    | €0.10 per 1000 units             |
| GBP      | 0.90    | £0.09 per 1000 units             |
| INR      | 92.00   | ₹9.20 per 1000 units             |
| JPY      | 148.30  | ¥14.83 per 1000 units            |
| KRW      | 1421.20 | ₩142.12 per 1000 units           |
| NOK      | 11.20   | NOK 1.12 per 1000 units          |
| NZD      | 1.80    | $0.18 per 1000 units             |
| SEK      | 11.50   | 1,15 kr. per 1000 units          |
| TWD      | 34.70   | NT$3.47 per 1000 units           |

† used to avoid rounding issues: at list price, 1 ECU corresponds to 10,000 Elastic Billing Units for Azure

## How the changes affect you

For customers paying in non-USD currencies, any future prepaid fees, or on-demand usage after the plan/price change are charged at the new currency exchange rate. The applicable rate is clearly displayed on the Azure Marketplace listing page, allowing you to stay informed about the pricing adjustments.

## Our commitment to you

We understand that pricing adjustments can raise questions or concerns, and we are here to support you throughout this process. Should you have any inquiries or need assistance, reach out to your Elastic account representative or Elastic Support at `support@elastic.co`.