﻿---
title: AWS Marketplace
description: 7-Day Free Trial Sign-Up: On the Elastic Cloud AWS marketplace page, click View purchase options, sign into your AWS account, then start using Elastic...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/aws-marketplace
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# AWS Marketplace
7-Day Free Trial Sign-Up: On the [Elastic Cloud AWS marketplace page](https://aws.amazon.com/marketplace/pp/prodview-voru33wi6xs7k), click **View purchase options**, sign into your AWS account, then start using Elastic Cloud.
<tip>
  The free trial includes provisioning of a single deployment and you are not charged for the first 7 days. Billing starts automatically after the 7-day trial period ends. Get started today!
</tip>

You can subscribe to Elastic Cloud directly from the AWS Marketplace. You then have the convenience of viewing your Elastic Cloud subscription as part of your AWS bill, and you do not have to supply any additional billing information to Elastic.
Some differences exist when you subscribe to Elastic Cloud through the AWS Marketplace:
- Billing starts automatically after the 7-day trial period.
- Previous Elastic Cloud accounts cannot be converted to use the AWS Marketplace. If you already have an account, you must use a different email address when you sign up for a subscription through the AWS Marketplace.
- Pricing is based on the AWS region, the size of your deployment, as well as some other parameters such as data transfer out, data transfer internode, snapshot storage, and snapshot APIs. For more details, check [Billing Dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/cloud-hosted-deployment-billing-dimensions).
- The consolidated charges for your Elastic Cloud subscription display in the AWS Marketplace billing console. It can take a day or two before new charges show up.
- Regardless of where your deployment is hosted (visible in the Elastic Cloud console), the AWS Marketplace charges for all AWS regions are metered in US East (Northern Virginia). As a result, US East (Northern Virginia) is listed as the region in the AWS Marketplace console.

For a detailed breakdown of your charges by deployment or by product, complete the following steps:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. From a deployment or project on the home page, select **Manage**.
3. From the lower navigation menu, select **Billing and Subscription**.
4. Find your breakdown on the **Usage** page.

To end your trial or unsubscribe from the service, delete your deployment(s).
Elastic provides different [subscription levels](https://www.elastic.co/subscriptions/cloud). During your 7-day trial you will automatically have an Enterprise level subscription. After the trial you can choose the subscription level.

## Before you begin

Note the following items before you subscribe:
- You cannot use an email address that already has an Elastic Cloud account. If you want to use the same account email address with AWS Marketplace billing, you must first change the email address on your existing account before setting up your new AWS Marketplace subscription. For instructions on how to change your email address in Elastic Cloud, check [update your email address](https://www.elastic.co/docs/cloud-account/update-your-email-address).
- If you want to manage deployments on the existing Elastic Cloud account with your AWS MP billing account, you must migrate your deployments over to the new MP billing account. To migrate, use a [custom repository](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/elastic-cloud-hosted) to take a snapshot and then restore that snapshot to a new deployment under your AWS Marketplace account.


## Subscribe to Elastic Cloud through the AWS Marketplace

To subscribe to Elastic Cloud through the AWS Marketplace:
1. Go to [Elastic Cloud on the AWS Marketplace](https://aws.amazon.com/marketplace/pp/B01N6YCISK) and click **View purchase options**.
2. Click **Subscribe** and then **Set Up Your Account** to continue.
3. Follow the steps displayed to complete the signup process.
   1. Ensure that you have the necessary AWS permissions required to complete a marketplace transaction.
2. Create a new Elastic Cloud account. This account is linked to your AWS Marketplace subscription.
3. (Optional) Use the Elastic Cloud CloudFormation template to quickly get started with Elastic. The template deploys the Elastic Stack in your Elastic Cloud account, and also provisions the Elastic Agent on a new EC2 instance in your AWS environment.
4. Navigate to Elastic Cloud to continue.
   <note>
   You can leave this page and return to it later. Select **Copy** to get a direct URL to the configuration page with your saved settings. You can also send the URL to an email address.
   </note>


## Troubleshooting

This section describes some scenarios that you may experience onboarding onto the marketplace offer. If you’re running into issues with your marketplace subscription or are encountering technical issues, create a support case or contact `support@elastic.co`.
- [I receive an error message telling me that I’m already signed up using an Elastic Cloud email address.](#ec-awsmp-account-collision01)
- [When I try to configure a new account from the AWS console, I get the Elastic Cloud login page, not the sign-up page. If I sign up to a new account it is not connected to the marketplace.](#ec-awsmp-account-collision02)
- [When I try to configure an account from the AWS console I get an error that An active AWS subscription already exists.](#ec-awsmp-account-collision03)


### I receive an error message telling me that I’m already signed up using an Elastic Cloud email address.

This occurs when you attempt to sign up to the marketplace offer using an email address that already exists in Elastic Cloud, such as part of a trial account. You have a few options:
- **Change the email address of your previous Elastic Cloud account** - Log in to your existing Elastic Cloud account and change the email address. Once changed, navigate back to the AWS console to finish setting up your marketplace subscription.
- **Sign up using a different email address** - Sign up to Elastic Cloud using a different email address.


### When I try to configure a new account from the AWS console, I get the Elastic Cloud login page, not the sign-up page. If I sign up to a new account it is not connected to the marketplace.

If the Elastic Cloud login page displays when coming from the AWS console, then an Elastic Cloud account is already connected to your marketplace subscription. Log into Elastic Cloud with that account to continue. If you can’t remember your password, use the **Forgot password?** link to reset your password.
If you can’t remember which email address you used to sign up to Elastic Cloud, or you need more help, contact `support@elastic.co`.

### When I try to configure an account from the AWS console I get an error that an active AWS subscription already exists.

This error occurs when you have already provisioned a marketplace subscription under your AWS user account. Each AWS user account can only subscribe to Elastic Cloud once.
If you wish to configure multiple marketplace subscriptions, you need to use a different AWS user account to create the marketplace subscription from the AWS console. Once the marketplace subscription is created in AWS, you can continue to configure the subscription in Elastic Cloud.