﻿---
title: Add plugins and extensions in Elastic Cloud Hosted
description: Plugins extend the core functionality of Elasticsearch. There are many suitable plugins, including: Discovery plugins, such as the cloud AWS plugin that...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/add-plugins-extensions
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Add plugins and extensions in Elastic Cloud Hosted
Plugins extend the core functionality of Elasticsearch. There are many suitable plugins, including:
- Discovery plugins, such as the cloud AWS plugin that allows discovering nodes on EC2 instances.
- Analysis plugins, to provide analyzers targeted at languages other than English.
- Scripting plugins, to provide additional scripting languages.

Plugins can come from different sources: the official ones created or at least maintained by Elastic, community-sourced plugins from other users, and plugins that you provide. Some of the official plugins are always provided with our service, and can be [enabled per deployment](https://www.elastic.co/docs/reference/elasticsearch/plugins/plugin-management).
There are two ways to add plugins to a hosted deployment in Elastic Cloud:
- [Enable one of the official plugins already available in Elastic Cloud](https://www.elastic.co/docs/reference/elasticsearch/plugins/plugin-management).
- [Upload a custom plugin and then enable it per deployment](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/upload-custom-plugins-bundles).

Custom plugins can include the official Elasticsearch plugins not provided with Elastic Cloud, any of the community-sourced plugins, or [plugins that you write yourself](https://www.elastic.co/docs/extend/elasticsearch). Uploading custom plugins is available only to Gold, Platinum, and Enterprise subscriptions. For more information, check [Upload custom plugins and bundles](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/upload-custom-plugins-bundles).
To learn more about the official and community-sourced plugins, refer to [Elasticsearch Plugins and Integrations](https://www.elastic.co/docs/reference/elasticsearch/plugins).
For a detailed guide with examples of using the Elastic Cloud API to create, get information about, update, and delete extensions and plugins, check [Managing plugins and extensions through the API](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/manage-plugins-extensions-through-api).
Plugins are not supported for Kibana. To learn more, check [Restrictions for Elasticsearch and Kibana plugins](/docs/deploy-manage/deploy/elastic-cloud/restrictions-known-problems#ec-restrictions-plugins).