﻿---
title: Elastic Cloud
description: Elastic Cloud allows you to centrally manage hosted deployments of the Elastic Stack and serverless projects for your Observability, Security, and Search...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud
products:
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Elastic Cloud
Elastic Cloud allows you to centrally manage [hosted deployments](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/cloud-hosted) of the Elastic Stack and [serverless projects](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless) for your Observability, Security, and Search use cases.
These hosted deployments and serverless projects are hosted on Elastic Cloud, through the cloud provider and regions of your choice, and are tied to your organization account.
You can check the operational status of Elastic Cloud at any time from [status.elastic.co](https://status.elastic.co/).

## Sign up

You can get started by creating an Elastic Cloud organization on [cloud.elastic.co](https://cloud.elastic.co/registration).
For more details on the available sign up options and trial information, go to [Sign up and create an organization](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/create-an-organization).

## Benefits of Elastic Cloud

Some of the unique benefits of Elastic Cloud include:
- Regular updates and improvements automatically deployed or made available.
- Built-in security, including encryption at rest.
- Central management of billing and licensing.
- Built-in tools for monitoring and scaling your Elastic Cloud resources.
- Central management of users, roles, and authentication, including integration with SSO providers.

For more information, refer to [Manage your Cloud organization](https://www.elastic.co/docs/deploy-manage/cloud-organization).

## Compare Elastic Cloud Hosted and Serverless

You can have multiple hosted deployments and serverless projects in the same Elastic Cloud organization, and each deployment type has its own specificities.

| Option                 | Serverless                                           | Hosted                                                                             |
|------------------------|------------------------------------------------------|------------------------------------------------------------------------------------|
| **Cluster management** | Fully managed by Elastic.                            | You provision and manage your hosted clusters. Shared responsibility with Elastic. |
| **Scaling**            | Autoscales out of the box.                           | Manual scaling or autoscaling available for you to enable.                         |
| **Upgrades**           | Automatically performed by Elastic.                  | You choose when to upgrade.                                                        |
| **Pricing**            | Individual per project type and based on your usage. | Based on deployment size and subscription level.                                   |
| **Performance**        | Autoscales based on your usage.                      | Manual scaling.                                                                    |
| **Solutions**          | Single solution per project.                         | Full Elastic Stack per deployment.                                                 |
| **User management**    | Elastic Cloud-managed users.                         | Elastic Cloud-managed users and native Kibana users.                               |
| **API support**        | Subset of [APIs](https://www.elastic.co/docs/api).   | All Elastic APIs.                                                                  |
| **Backups**            | Projects automatically backed up by Elastic.         | Your responsibility with Snapshot & Restore.                                       |
| **Data retention**     | Editable on data streams.                            | Index Lifecycle Management.                                                        |


## APIs

Elastic Cloud offers APIs to manage your organization and its resources. Check the [Elastic Cloud](https://www.elastic.co/docs/api/doc/cloud/) and [Elastic Cloud serverless](https://www.elastic.co/docs/api/doc/elastic-cloud-serverless/) APIs.
More tools are available for you to make the most of your Elastic Cloud organization and Elasticsearch. Refer to [Tools and APIs for Elastic Cloud](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/tools-apis).