﻿---
title: Detailed deployment comparison
description: This reference provides detailed comparisons of features and capabilities across Elastic's deployment options: fully self-managed clusters, Elastic Cloud...
url: https://www.elastic.co/docs/deploy-manage/deploy/deployment-comparison
---

# Detailed deployment comparison
This reference provides detailed comparisons of features and capabilities across Elastic's deployment options: [fully self-managed clusters](https://www.elastic.co/docs/deploy-manage/deploy/self-managed), [Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise) (ECE), [Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s) (ECK), [Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/cloud-hosted) (ECH), and [Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless). For a high-level overview of deployment types and guidance on choosing between them, refer to the [Deploy and manage overview](https://www.elastic.co/docs/deploy-manage/deploy).
For more details about feature availability in Serverless, refer to [Compare Elastic Cloud Hosted and Serverless](/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-feature-categories).

## Security


| Feature/capability                                                                                                     | Fully self-managed, ECE, ECK | ECH             | Serverless                            |
|------------------------------------------------------------------------------------------------------------------------|------------------------------|-----------------|---------------------------------------|
| [Security configurations](https://www.elastic.co/docs/deploy-manage/security)                                          | Full control                 | Limited control | Limited control                       |
| [Authentication realms](https://www.elastic.co/docs/deploy-manage/users-roles)                                         | Available                    | Available       | Available, through Elastic Cloud only |
| [Custom roles](https://www.elastic.co/docs/deploy-manage/users-roles)                                                  | Available                    | Available       | Available                             |
| [Audit logging](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/security-event-audit-logging) | Available                    | Available       | No                                    |


## Infrastructure and cluster management


| Feature/capability                                                                                                                   | Fully self-managed                                                                                   | ECE                                                                                                  | ECK                                                                                                  | ECH                                      | Serverless                               |
|--------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------|------------------------------------------|------------------------------------------|
| Hosting                                                                                                                              | Any infrastructure                                                                                   | Any infrastructure                                                                                   | Any infrastructure                                                                                   | Elastic Cloud through AWS, Azure, or GCP | Elastic Cloud through AWS, Azure, or GCP |
| Hardware configuration                                                                                                               | Full control                                                                                         | Full control                                                                                         | Full control                                                                                         | Limited control                          | Managed by Elastic                       |
| [Autoscaling](https://www.elastic.co/docs/deploy-manage/autoscaling)                                                                 | No                                                                                                   | Available                                                                                            | Available                                                                                            | Available                                | Automatic                                |
| [Data tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) management                                                 | Through [ILM policies](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) | Through [ILM policies](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) | Through [ILM policies](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) | Available                                | No data tiers                            |
| [Snapshot management](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore)                                          | Custom                                                                                               | Custom                                                                                               | Available                                                                                            | Available                                | Managed by Elastic                       |
| [High availability and disaster recovery](https://www.elastic.co/docs/deploy-manage/production-guidance/availability-and-resilience) | Available                                                                                            | Available                                                                                            | Available                                                                                            | Available                                | Managed by Elastic                       |
| [Shard management and replicas](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards)            | Available                                                                                            | Available                                                                                            | Available                                                                                            | Available                                | Managed by Elastic                       |


## Monitoring


| Feature/capability                                                                | Fully self-managed, ECE, ECK  | ECH                           | Serverless                                                  |
|-----------------------------------------------------------------------------------|-------------------------------|-------------------------------|-------------------------------------------------------------|
| [Deployment health monitoring](https://www.elastic.co/docs/deploy-manage/monitor) | AutoOps or monitoring cluster | AutoOps or monitoring cluster | Managed by Elastic                                          |
| [Alerting](https://www.elastic.co/docs/explore-analyze/alerts-cases)              | Watcher or Kibana alerts      | Watcher or Kibana alerts      | Alerts ([why?](/docs/explore-analyze/alerts-cases#watcher)) |


## Data lifecycle


| Feature/capability                                                                          | Fully self-managed, ECE, ECK           | ECH                                    | Serverless                                                      |
|---------------------------------------------------------------------------------------------|----------------------------------------|----------------------------------------|-----------------------------------------------------------------|
| [Data lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle)              | ILM, data tiers, data stream lifecycle | ILM, data tiers, data stream lifecycle | Data stream lifecycle ([why?](/docs/manage-data/lifecycle#ilm)) |
| [Snapshot management](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore) | Custom                                 | Available                              | Managed by Elastic                                              |


## Integrations and extensions


| Feature/capability                                                                                         | Fully self-managed, ECE, ECK | ECH       | Serverless                                                                           |
|------------------------------------------------------------------------------------------------------------|------------------------------|-----------|--------------------------------------------------------------------------------------|
| Custom plugins and bundles                                                                                 | Available                    | Available | No                                                                                   |
| [Self-managed connectors](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors) | Available                    | Limited   | Limited                                                                              |
| [Elasticsearch-Hadoop integration](https://www.elastic.co/docs/reference/elasticsearch-hadoop)             | Available                    | Available | No                                                                                   |
| [Cross cluster search (CCS)](https://www.elastic.co/docs/explore-analyze/cross-cluster-search)             | Available                    | Available | [Planned](https://www.elastic.co/cloud/serverless/roadmap) (as cross project search) |
| [Cross cluster replication](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication)     | Available                    | Available | [Planned](https://www.elastic.co/cloud/serverless/roadmap)                           |


## Development and testing features


| Feature/capability               | Fully self-managed, ECE, ECK | ECH | Serverless |
|----------------------------------|------------------------------|-----|------------|
| Advanced testing and development | Available                    | No  | No         |
| Java (JVM) customization         | Available                    | No  | No         |