﻿---
title: Use an Elasticsearch cluster managed by ECK
description: Managing APM Server, Kibana and Elasticsearch with ECK allows a smooth and secured integration between the stack components. The output configuration...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/use-an-elasticsearch-cluster-managed-by-eck
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Use an Elasticsearch cluster managed by ECK
Managing APM Server, Kibana and Elasticsearch with ECK allows a smooth and secured integration between the stack components. The output configuration of the APM Server is setup automatically to establish a trust relationship with Elasticsearch. Specifying the Kibana reference allows ECK to automatically configure the [Kibana endpoint](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-kibana-endpoint).
1. To deploy an APM Server and connect it to the Elasticsearch cluster and Kibana instance you created in [Deploy an Elasticsearch cluster](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-deployment-quickstart), apply the following specification:
   ```yaml
   cat <<EOF | kubectl apply -f -
   apiVersion: apm.k8s.elastic.co/v1
   kind: ApmServer
   metadata:
     name: apm-server-quickstart
     namespace: default
   spec:
     version: 9.3.0
     count: 1
     elasticsearchRef:
       name: quickstart
     kibanaRef:
       name: quickstart 
   EOF
   ```

<note>
  Starting with version 8.0.0 the following Kibana configuration is required to run APM Server
</note>

```yaml
apiVersion: kibana.k8s.elastic.co/v1
kind: Kibana
config:
  xpack.fleet.packages:
  - name: apm
    version: latest
```

By default `elasticsearchRef` targets all nodes in your Elasticsearch cluster. If you want to direct traffic to specific nodes of your cluster, refer to [*Traffic Splitting*](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/requests-routing-to-elasticsearch-nodes) for more information and examples.
1. Monitor APM Server deployment.
   You can retrieve details about the APM Server instance:
   ```sh
   kubectl get apmservers
   ```
   ```sh
   NAME                     HEALTH    NODES    VERSION   AGE
   apm-server-quickstart    green     1        9.3.0      8m
   ```
   And you can list all the Pods belonging to a given deployment:
   ```sh
   kubectl get pods --selector='apm.k8s.elastic.co/name=apm-server-quickstart'
   ```
   ```sh
   NAME                                                READY   STATUS    RESTARTS   AGE
   apm-server-quickstart-apm-server-69b447ddc5-fflc6   1/1     Running   0          2m50s
   ```