﻿---
title: Pod update strategy for Logstash on ECK
description: The operator takes a Pod down to restart and applies a new configuration value. All Pods are restarted in reverse ordinal order. When updateStrategy is...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/update-strategy-logstash
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Pod update strategy for Logstash on ECK
The operator takes a Pod down to restart and applies a new configuration value. All Pods are restarted in reverse ordinal order.

## Default behavior

When `updateStrategy` is not present in the specification, it defaults to the following:
```yaml
spec:
  updateStrategy:
    type: "RollingUpdate" 
    rollingUpdate:
      partition: 0        
      maxUnavailable: 1   
```


## OnDelete

```yaml
spec:
  updateStrategy:
    type: "OnDelete"
```

`OnDelete` strategy does not automatically update Pods when a modification is made. You need to restart Pods yourself.