﻿---
title: Tools and APIs for Elastic Cloud on Kubernetes
description: Review key resources that can be used to interact with and manage your Elastic Cloud on Kubernetes operator and deployments. You can use the following...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/tools-apis
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Tools and APIs for Elastic Cloud on Kubernetes
Review key resources that can be used to interact with and manage your Elastic Cloud on Kubernetes operator and deployments.

## APIs

You can use the following APIs in an Elastic Cloud on Kubernetes environment.
<tip>
  Refer to [Elastic API keys](https://www.elastic.co/docs/deploy-manage/api-keys) to learn how to generate API keys for your environment.
</tip>


### Orchestration APIs

You can use the [Elastic Cloud on Kubernetes API](https://www.elastic.co/docs/reference/cloud-on-k8s/api-docs) to create and manage Elastic Stack components using Elastic-provided [Custom Resource Definitions (CRDs)](https://kubernetes.io/docs/concepts/extend-kubernetes/api-extension/custom-resources/#customresourcedefinitions).

### APIs to interact with data and solution features

The following APIs allow you to interact with your Elasticsearch cluster, its data, and the features available to you in your Elastic Cloud on Kubernetes deployments.
<tip>
  Refer to [Elasticsearch API conventions](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions) to learn about headers and request body conventions, and to view examples.
</tip>

- [Elasticsearch APIs](https://www.elastic.co/docs/api/doc/elasticsearch/): This set of APIs allows you to interact directly with the Elasticsearch nodes in your deployment. You can ingest data, run search queries, check the health of your clusters, manage snapshots, and more.
- [Kibana APIs](https://www.elastic.co/docs/api/doc/kibana/): Many Kibana features can be accessed through these APIs, including Kibana objects, patterns, and dashboards, as well as user roles and user sessions. You can use these APIs to configure alerts and actions, and to access health details for the [Kibana Task Manager](https://www.elastic.co/docs/deploy-manage/distributed-architecture/kibana-tasks-management).

Some other Elastic products have APIs to support machine-to-machine operations:
- [APM event intake API](https://www.elastic.co/docs/solutions/observability/apm/elastic-apm-events-intake-api)
- [Fleet APIs](https://www.elastic.co/docs/reference/fleet/fleet-api-docs)
- [Logstash APIs](https://www.elastic.co/docs/reference/logstash/monitoring-logstash)


## Tools

- [ECK diagnostics tool](https://www.elastic.co/docs/troubleshoot/deployments/cloud-on-k8s/run-eck-diagnostics): Use the `eck-diagnostics` command line tool to create a diagnostic archive to help troubleshoot issues with ECK.