﻿---
title: Settings managed by ECK
description: The following Elasticsearch settings are managed by ECK: cluster.name, discovery.seed_hosts, discovery.seed_providers, discovery.zen.minimum_master_nodes,...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/settings-managed-by-eck
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Settings managed by ECK
The following Elasticsearch settings are managed by ECK:
- `cluster.name`
- `discovery.seed_hosts`
- `discovery.seed_providers`
- `discovery.zen.minimum_master_nodes`
- `cluster.initial_master_nodes`
- `network.host`
- `network.publish_host`
- `path.data`
- `path.logs`
- `xpack.security.authc.reserved_realm.enabled`
- `xpack.security.enabled`
- `xpack.security.http.ssl.certificate`
- `xpack.security.http.ssl.enabled`
- `xpack.security.http.ssl.key`
- `xpack.security.transport.ssl.enabled`
- `xpack.security.transport.ssl.verification_mode`

The following Elasticsearch settings are not supported by ECK:
- `xpack.security.http.ssl.client_authentication`: `required`

<warning>
  It is not recommended to change these ECK settings. We don’t support user-provided Elasticsearch configurations that use any of these settings.
</warning>