﻿---
title: Security context
description: In Kubernetes, a securityContext defines privilege and access control settings for a Pod or Container. You can set up it through the podTemplate section...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/security-context
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Security context
In Kubernetes, a [`securityContext`](https://kubernetes.io/docs/tasks/configure-pod-container/security-context/) defines privilege and access control settings for a Pod or Container. You can set up it through the `podTemplate` section of an Elastic resource specification.

## Default Elasticsearch security context

As of version 8.8.0, the Elasticsearch container and ECK managed sidecars and init containers are running with the following security context:
```yaml
securityContext:
  allowPrivilegeEscalation: false
  capabilities:
    drop:
    - ALL
  privileged: false
  readOnlyRootFilesystem: true 
```


## Running older versions of Elasticsearch as non-root

<note>
  when running on Red Hat OpenShift a random user ID is [automatically assigned](https://cloud.redhat.com/blog/a-guide-to-openshift-and-uids) and the following instructions do not apply.
</note>

In versions of Elasticsearch before 8.0.0, the Elastisearch container is run as root and its entrypoint is responsible to run the Elasticsearch process with the `elasticsearch` user (defined with ID 1000). In the background, ECK uses an `initContainer` to make sure that the data volume is writable for the `elasticsearch` user.
To run the Elastisearch container as a non-root user, you need to configure the Elasticsearch manifest with an appropriate security context to make the data volume writable to the `elasticsearch` user by specifying the right group ID through the `fsGroup`.
Kubernetes recursively changes ownership and permissions for the contents of each volume to match the `fsGroup` specified in a Pod’s securityContext when that volume is mounted and makes all processes of the containers part of the supplementary group ID.
For example, if you force the Pod to run as user `1234`, you need to set `fsGroup` accordingly to `1234`:
```yaml
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
metadata:
  name: quickstart
spec:
  version: 9.3.0
spec:
  nodeSets:
  - name: default
    count: 3
    podTemplate:
      spec:
        securityContext:
          runAsUser: 1234 
          fsGroup: 1234 
```