﻿---
title: Securing Logstash API
description: Access to the Logstash Monitoring APIs use HTTPS by default - the operator will set the values  api.ssl.enabled: true, api.ssl.keystore.path and api.ssl.keystore.password...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/securing-logstash-api
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Securing Logstash API
## Enable HTTPS

Access to the [Logstash Monitoring APIs](https://www.elastic.co/docs/reference/logstash/monitoring-logstash#monitoring-api-security) use HTTPS by default - the operator will set the values  `api.ssl.enabled: true`, `api.ssl.keystore.path` and `api.ssl.keystore.password`.
You can further secure the Logstash Monitoring APIs by requiring HTTP Basic authentication by setting `api.auth.type: basic`, and providing the relevant credentials `api.auth.basic.username` and `api.auth.basic.password`:
```yaml
apiVersion: v1
kind: Secret
metadata:
  name: logstash-api-secret
stringData:
  API_USERNAME: "AWESOME_USER"   
  API_PASSWORD: "T0p_Secret"     
---
apiVersion: logstash.k8s.elastic.co/v1alpha1
kind: Logstash
metadata:
  name: logstash-sample
spec:
  version: 9.3.0
  count: 1
  config:
    api.auth.type: basic
    api.auth.basic.username: "${API_USERNAME}"   
    api.auth.basic.password: "${API_PASSWORD}"   
  podTemplate:
    spec:
      containers:
        - name: logstash
          envFrom:
            - secretRef:
                name: logstash-api-secret   
```

An alternative is to set up [keystore](/docs/deploy-manage/deploy/cloud-on-k8s/advanced-configuration-logstash#k8s-logstash-keystore) to resolve `${API_USERNAME}` and `${API_PASSWORD}`
<note>
  The variable substitution in `config` does not support the default value syntax.
</note>


## TLS keystore

The TLS Keystore is automatically generated and includes a certificate and a private key, with default password protection set to `changeit`. This password can be modified by configuring the `api.ssl.keystore.password` value.
```yaml
apiVersion: logstash.k8s.elastic.co/v1alpha1
kind: Logstash
metadata:
  name: logstash-sample
spec:
  count: 1
  version: 9.3.0
  config:
    api.ssl.keystore.password: "${SSL_KEYSTORE_PASSWORD}"
```


## Provide your own certificate

If you want to use your own certificate, the required configuration is similar to Elasticsearch. Configure the certificate in `api` Service. Check [Custom HTTP certificate](https://www.elastic.co/docs/deploy-manage/security/secure-cluster-communications).
```yaml
apiVersion: logstash.k8s.elastic.co/v1alpha1
kind: Logstash
metadata:
  name: logstash-sample
spec:
  version: 9.3.0
  count: 1
  elasticsearchRef:
    name: "elasticsearch-sample"
  services:
    - name: api   
      tls:
        certificate:
          secretName: my-cert
```


## Disable TLS

You can disable TLS by disabling the generation of the self-signed certificate in the API service definition
```yaml
apiVersion: logstash.k8s.elastic.co/v1alpha1
kind: Logstash
metadata:
  name: logstash-sample
spec:
  version: 9.3.0
  count: 1
  elasticsearchRef:
    name: "elasticsearch-sample"
  services:
    - name: api
      tls:
        selfSignedCertificate:
          disabled: true
```