﻿---
title: Recipes
description: This section includes recipes that provide configuration examples for some common use cases. Expose Elasticsearch and Kibana using a Google Cloud Load...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/recipes
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Recipes
This section includes recipes that provide configuration examples for some common use cases.
- [Expose Elasticsearch and Kibana using a Google Cloud Load Balancer (GCLB)](https://github.com/elastic/cloud-on-k8s/tree/main/config/recipes/gclb)
- [Expose Elasticsearch and Kibana using Istio ingress gateway](https://github.com/elastic/cloud-on-k8s/tree/main/config/recipes/istio-gateway)
- [Using Logstash with ECK](https://github.com/elastic/cloud-on-k8s/tree/main/config/recipes/logstash)
- [Expose Elastic Maps Server and Kibana using a Kubernetes Ingress](https://github.com/elastic/cloud-on-k8s/tree/main/config/recipes/maps)
- [Secure your cluster with Pod Security Policies](https://github.com/elastic/cloud-on-k8s/tree/main/config/recipes/psp)
- [Use Traefik to expose Elastic Stack applications](https://github.com/elastic/cloud-on-k8s/tree/main/config/recipes/traefik)
- [Deploy Elasticsearch, Kibana, Elastic Fleet Server and Elastic Agent within GKE Autopilot](https://github.com/elastic/cloud-on-k8s/tree/main/config/recipes/autopilot)

<warning>
  Compared to other configuration examples that are consistently tested, like [fleet-managed Elastic Agent on ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configuration-examples-fleet), [standalone Elastic Agent on ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configuration-examples-standalone), or [Beats on ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configuration-examples-beats), the recipes in this section are not regularly tested by our automation system, and therefore should not be considered to be production-ready.
</warning>

<admonition title="Support scope for Ingress Controllers">
  [Ingress](https://kubernetes.io/docs/concepts/services-networking/ingress/) is a standard Kubernetes concept. While ECK-managed workloads can be publicly exposed using ingress resources, and we provide [example configurations](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/recipes), setting up an Ingress controller requires in-house Kubernetes expertise.If ingress configuration is challenging or unsupported in your environment, consider using standard `LoadBalancer` services as a simpler alternative.
</admonition>