﻿---
title: Readiness probe
description: By default, the readiness probe checks that the Pod responds to HTTP requests within a timeout of three seconds. This is acceptable in most cases. However,...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/readiness-probe
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Readiness probe
## Elasticsearch versions before 8.2.0

By default, the readiness probe checks that the Pod responds to HTTP requests within a timeout of three seconds. This is acceptable in most cases. However, when the cluster is under heavy load, you might need to increase the timeout. This allows the Pod to stay in a `Ready` state and be part of the Elasticsearch service even if it is responding slowly. To adjust the timeout, set the `READINESS_PROBE_TIMEOUT` environment variable in the Pod template and update the readiness probe configuration with the new timeout.
This example describes how to increase the API call timeout to ten seconds and the overall check time to twelve seconds:
```yaml
spec:
  version: 9.3.0
  nodeSets:
    - name: default
      count: 1
      podTemplate:
        spec:
          containers:
          - name: elasticsearch
            readinessProbe:
              exec:
                command:
                - bash
                - -c
                - /mnt/elastic-internal/scripts/readiness-probe-script.sh
              failureThreshold: 3
              initialDelaySeconds: 10
              periodSeconds: 12
              successThreshold: 1
              timeoutSeconds: 12
            env:
            - name: READINESS_PROBE_TIMEOUT
              value: "10"
```

<note>
  Updating this value requires restarting the Pods.
</note>


## Elasticsearch versions 8.2.0 and later

We do not recommend overriding the default readiness probe on Elasticsearch 8.2.0 and later. ECK configures a socket-based readiness probe using the Elasticsearch [readiness port feature](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#tcp-readiness-port) which is not influenced by the load on the Elasticsearch cluster.