﻿---
title: Quickstart: Running standalone Elastic Agent on Elastic Cloud on Kubernetes
description: Apply the following specification to deploy Elastic Agent with the System metrics integration to harvest CPU metrics from the Agent Pods. ECK automatically...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/quickstart-standalone
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Quickstart: Running standalone Elastic Agent on Elastic Cloud on Kubernetes
1. Apply the following specification to deploy Elastic Agent with the System metrics integration to harvest CPU metrics from the Agent Pods. ECK automatically configures the secured connection to an Elasticsearch cluster named `quickstart`, created in [Deploy an Elasticsearch cluster](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-deployment-quickstart).
   ```yaml
   cat <<EOF | kubectl apply -f -
   apiVersion: agent.k8s.elastic.co/v1alpha1
   kind: Agent
   metadata:
     name: quickstart
   spec:
     version: 9.3.0
     elasticsearchRefs:
     - name: quickstart
     daemonSet:
       podTemplate:
         spec:
           securityContext:
             runAsUser: 0 
     config:
       inputs:
         - name: system-1
           revision: 1
           type: system/metrics
           use_output: default
           meta:
             package:
               name: system
               version: 0.9.1
           data_stream:
             namespace: default
           streams:
             - id: system/metrics-system.cpu
               data_stream:
                 dataset: system.cpu
                 type: metrics
               metricsets:
                 - cpu
               cpu.metrics:
                 - percentages
                 - normalized_percentages
               period: 10s
   EOF
   ```
   Check [Configuration examples](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configuration-examples-standalone) for more ready-to-use manifests.
2. Monitor the status of Elastic Agent.
   ```sh
   kubectl get agent
   ```
   ```sh
   NAME            HEALTH   AVAILABLE   EXPECTED   VERSION   AGE
   quickstart      green    3           3          9.3.0    15s
   ```
3. List all the Pods that belong to a given Elastic Agent specification.
   ```sh
   kubectl get pods --selector='agent.k8s.elastic.co/name=quickstart'
   ```
   ```sh
   NAME                     READY   STATUS    RESTARTS   AGE
   quickstart-agent-6bcxr   1/1     Running   0          68s
   quickstart-agent-t49fd   1/1     Running   0          68s
   quickstart-agent-zqp55   1/1     Running   0          68s
   ```
4. Access logs for one of the Pods.
   ```sh
   kubectl logs -f quickstart-agent-6bcxr
   ```
5. Access the CPU metrics ingested by Elastic Agent.
   You have two options:
   - Follow the Elasticsearch deployment [guide](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-deployment-quickstart) and run:
  ```sh
  curl -u "elastic:$PASSWORD" -k "https://localhost:9200/metrics-system.cpu-*/_search"
  ```
- Follow the Kibana deployment [guide](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/kibana-instance-quickstart), log in and go to **Kibana** > **Discover**.