﻿---
title: Deploy Elastic Package Registry on Elastic Cloud on Kubernetes
description: The Elastic Package Registry is a service that stores Elastic package definitions in a central location, making it easier to manage integrations in air-gapped...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/package-registry
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available since 3.3
---

# Deploy Elastic Package Registry on Elastic Cloud on Kubernetes
The Elastic Package Registry is a service that stores Elastic package definitions in a central location, making it easier to manage integrations in air-gapped environments or when you need to use a private registry. You can deploy and manage the Elastic Package Registry (EPR) as a Kubernetes resource using ECK. When deployed with ECK, the registry runs as a containerized service in your Kubernetes cluster and can be used by Kibana instances to download and manage integration packages for Fleet.

## Deploy the Package Registry

To deploy the Elastic Package Registry, create a `PackageRegistry` resource:
```yaml
apiVersion: packageregistry.k8s.elastic.co/v1alpha1
kind: PackageRegistry
metadata:
  name: package-registry-sample
  namespace: default
spec:
  version: 9.3.0
  count: 1
```

The operator automatically creates the necessary Kubernetes resources, including:
- A Deployment for the Elastic Package Registry pods
- A Service to expose the Elastic Package Registry within your cluster
- TLS certificates for secure communication


## Connect Kibana to the Package Registry

After deploying the Elastic Package Registry, configure your Kibana instance to use it by setting the `spec.packageRegistryRef` field:
```yaml
apiVersion: kibana.k8s.elastic.co/v1
kind: Kibana
metadata:
  name: kibana-sample
  namespace: default
spec:
  version: 9.3.0
  count: 1
  packageRegistryRef:
    name: package-registry-sample
```

Refer to the [recipes directory](https://github.com/elastic/cloud-on-k8s/tree/3.3/config/recipes/packageregistry) in the ECK source repository for additional configuration examples.

## Troubleshooting


### Packages are not available

Since the Elastic Package Registry distribution images contain a snapshot of packages, if you are seeing issues where packages are not available, ensure you're using the correct image version that is equal to or greater than your Elastic Stack version. For the latest packages, use the `production` or `lite` distribution tags, for example:
- `docker.elastic.co/package-registry/distribution:production` - All packages from the production registry
- `docker.elastic.co/package-registry/distribution:lite` - Subset of commonly used packages

```yaml
apiVersion: packageregistry.k8s.elastic.co/v1alpha1
kind: PackageRegistry
metadata:
  name: package-registry-sample
  namespace: default
spec:
  version: 9.3.0
  count: 1
  image: docker.elastic.co/package-registry/distribution:production-9.3.0
```


## See also

- [Configuration for Fleet managed agents on Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configuration-fleet)
- [Running ECK in air-gapped environments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/air-gapped-install)
- [Set the proxy URL of the Elastic Package Registry](https://www.elastic.co/docs/reference/fleet/epr-proxy-setting)
- [Run Elastic Agents in an air-gapped environment > Host your own Elastic Package Registry](/docs/reference/fleet/air-gapped#air-gapped-diy-epr)