﻿---
title: Orchestrate other Elastic applications
description: This section explains how to deploy and configure various Elastic Stack applications within Elastic Cloud on Kubernetes (ECK). The following guides provide...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/orchestrate-other-elastic-applications
---

# Orchestrate other Elastic applications
This section explains how to deploy and configure various Elastic Stack applications within Elastic Cloud on Kubernetes (ECK).
<tip>
  This content applies to APM Server, Beats, Elastic Agent, Elastic Maps Server, and Logstash applications. To orchestrate an Elasticsearch cluster or Kibana, refer to [Manage deployments in Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/manage-deployments).
</tip>

The following guides provide specific instructions for deploying and configuring each application on ECK:
- [APM Server](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/apm-server)
- [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops) <applies-to>Elastic Cloud on Kubernetes: Generally available since 3.3</applies-to>
- [Standalone Elastic Agent](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/standalone-elastic-agent)
- [Fleet-managed Elastic Agent](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/fleet-managed-elastic-agent)
- [Elastic Maps Server](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elastic-maps-server)
- [Beats](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/beats)
- [Logstash](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/logstash)
- [Elastic Package Registry](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/package-registry)

<note>
  Enterprise Search is not available in Elastic Stack versions 9.0 and later. To deploy or manage Enterprise Search in earlier versions, refer to the [previous ECK documentation](https://www.elastic.co/guide/en/cloud-on-k8s/2.16/k8s-enterprise-search.html).
</note>

When orchestrating any of these applications, also consider the following topics:
- [Elastic Stack Helm Chart](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/managing-deployments-using-helm-chart)
- [Recipes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/recipes)
- [Secure the Elastic Stack](https://www.elastic.co/docs/deploy-manage/security)
- [Access Elastic Stack services](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/accessing-services)
- [Customize Pods](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/customize-pods)
- [Manage compute resources](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/manage-compute-resources)
- [Autoscaling stateless applications](/docs/deploy-manage/autoscaling/autoscaling-in-eck#k8s-stateless-autoscaling)
- [Elastic Stack configuration policies](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elastic-stack-configuration-policies)
- [Upgrade the Elastic Stack version](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster)
- [Connect to external Elastic resources](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/connect-to-external-elastic-resources)