﻿---
title: Node configuration
description: For more information on Elasticsearch settings, check Configuring Elasticsearch. 
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/node-configuration
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Node configuration
Elasticsearch settings that are typically defined in the `elasticsearch.yml` configuration file can be specified for a set of nodes in the `spec.nodeSets[?].config` section of the Elasticsearch resource manifest.
Some settings are managed by ECK. It is not recommended to change these managed settings. For a complete list, refer to [Settings managed by ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/settings-managed-by-eck).
```yaml
spec:
  nodeSets:
  - name: masters
    count: 3
    config:
      # On Elasticsearch versions before 7.9.0, replace the node.roles configuration with the following:
      # node.master: true
      node.roles: ["master"]
      xpack.ml.enabled: true
  - name: data
    count: 10
    config:
      # On Elasticsearch versions before 7.9.0, replace the node.roles configuration with the following:
      # node.master: false
      # node.data: true
      # node.ingest: true
      # node.ml: true
      # node.transform: true
      node.roles: ["data", "ingest", "ml", "transform"]
```

<warning>
  ECK parses Elasticsearch configuration and normalizes it to YAML. Consequently, some Elasticsearch configuration schema are impossible to express with ECK and, therefore, must be set using [dynamic cluster settings](/docs/deploy-manage/deploy/self-managed/configure-elasticsearch#cluster-setting-types). For example:
  ```yaml
  spec:
    nodeSets:
    - name: data
      # ...
      config:
        cluster.max_shards_per_node: 1000
        cluster.max_shards_per_node.frozen: 1000
      # ...
  ```
</warning>

For more information on Elasticsearch settings, check [Configuring Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch).