﻿---
title: Elastic Stack Helm chart
description: Starting from ECK 2.4.0, a Helm chart is available for managing Elastic Stack resources using the ECK Operator. It is available from the Elastic Helm...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/managing-deployments-using-helm-chart
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Elastic Stack Helm chart
Starting from ECK 2.4.0, a Helm chart is available for managing Elastic Stack resources using the ECK Operator. It is available from the Elastic Helm repository and can be added to your Helm repository list by running the following command:
```sh
helm repo add elastic https://helm.elastic.co
helm repo update
```

<note>
  The minimum supported version of Helm is 3.2.0.
</note>

The Elastic Stack (`eck-stack`) Helm chart is built on top of individual charts such as `eck-elasticsearch` and `eck-kibana`. For more details on its structure and dependencies, refer to the [chart repository](https://github.com/elastic/cloud-on-k8s/tree/main/deploy/eck-stack/).
The chart enables you to deploy the core components (Elasticsearch and Kibana) together, along with other Elastic Stack applications if needed, under the same chart release.
The following sections guide you through common installation, configuration, and upgrade use cases, and assume basic familiarity with [Helm](https://helm.sh/docs/). This guide does not provide a comprehensive introduction to Helm itself. Choose the command that best fits your setup.
<tip>
  All the provided examples deploy the applications in a namespace named `elastic-stack`. Consider adapting the commands to your use case.
</tip>


## Elasticsearch and Kibana

Similar to the quickstart examples for Elasticsearch and Kibana, this section describes how to setup an Elasticsearch cluster with a simple Kibana instance managed by ECK, and how to customize a deployment using the eck-stack Helm chart’s values.
```sh
# Install an eck-managed Elasticsearch and Kibana using the default values, which deploys the quickstart examples.
helm install es-kb-quickstart elastic/eck-stack -n elastic-stack --create-namespace
```


### Customize Elasticsearch and Kibana installation with example values

You can find example Helm values files for deploying and managing more advanced Elasticsearch and Kibana setups [in the project repository](https://github.com/elastic/cloud-on-k8s/tree/3.3/deploy/eck-stack/examples).
To use one or more of these example configurations, use the `--values` Helm option, as seen in the following section.
```sh
# Install an eck-managed Elasticsearch and Kibana using the Elasticsearch node roles example with hot, warm, and cold data tiers, and the Kibana example customizing the http service.
helm install es-quickstart elastic/eck-stack -n elastic-stack --create-namespace \
    --values https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/deploy/eck-stack/examples/elasticsearch/hot-warm-cold.yaml \
    --values https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/deploy/eck-stack/examples/kibana/http-configuration.yaml
```


## Fleet Server with Elastic Agents along with Elasticsearch and Kibana

The following section builds upon the previous section, and allows installing Fleet Server, and Fleet-managed Elastic Agents along with Elasticsearch and Kibana.
```sh
# Install an eck-managed Elasticsearch, Kibana, Fleet Server, and managed Elastic Agents using custom values.
helm install eck-stack-with-fleet elastic/eck-stack \
    --values https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/deploy/eck-stack/examples/agent/fleet-agents.yaml -n elastic-stack
```


## Logstash along with Elasticsearch, Kibana and Beats

The following section builds upon the previous sections, and allows installing Logstash along with Elasticsearch, Kibana and Beats.
```sh
# Install an eck-managed Elasticsearch, Kibana, Beats and Logstash using custom values.
helm install eck-stack-with-logstash elastic/eck-stack \
    --values https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/deploy/eck-stack/examples/logstash/basic-eck.yaml -n elastic-stack
```


## Standalone Elastic APM Server along with Elasticsearch and Kibana

The following section builds upon the previous sections, and allows installing a standalone Elastic APM Server along with Elasticsearch and Kibana.
```sh
# Install an eck-managed Elasticsearch, Kibana, and standalone APM Server using custom values.
helm install eck-stack-with-apm-server elastic/eck-stack \
    --values https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/deploy/eck-stack/examples/apm-server/basic.yaml -n elastic-stack
```


## AutoOps along with Elasticsearch

<applies-to>
  - Elastic Cloud on Kubernetes: Generally available since 3.3
</applies-to>

Use the following code to connect your ECK-managed Elasticsearch clusters to [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops) using Helm.
```sh
# Install an eck-managed Elasticsearch cluster and connect to AutoOps using custom values.
helm install eck-stack-with-autoops elastic/eck-stack \
    --values https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/deploy/eck-stack/examples/autoops/basic.yaml -n elastic-stack
```

The `eck-autoops-agent-policy` chart creates an `AutoOpsAgentPolicy` resource that connects your Elasticsearch clusters to AutoOps. The ECK operator handles the creation of API keys, agent configuration, and the deployment of Elastic Agent required to send metrics to AutoOps.
To connect to AutoOps using the installation wizard, refer to [Connect your ECE, ECK, or self-managed cluster to AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops).

## Package Registry along with Elasticsearch and Kibana

<applies-to>
  - Elastic Cloud on Kubernetes: Generally available since 3.3
</applies-to>

The following section describes how to install a Elastic Package Registry resource along with Elasticsearch, Kibana and Fleet Server.
```sh
# Install an eck-managed Elasticsearch, Kibana and Fleet Server and connect to Elastic Package Registry using custom values.
helm install eck-stack-with-package-registry elastic/eck-stack \
    --values https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/deploy/eck-stack/examples/package-registry/basic-eck.yaml -n elastic-stack
```

The `eck-package-registry` chart creates a `PackageRegistry` resource that connects your Kibana instance to the Elastic Package Registry. Elastic Cloud on Kubernetes automatically handles the creation of the Elastic Package Registry and the connection to Kibana and Fleet Server.
For more information about configuring the Elastic Package Registry, refer to the [Deploy Elastic Package Registry on Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/package-registry).

## Enterprise Search server along with Elasticsearch and Kibana

Enterprise Search is not available in Elastic Stack versions 9.0 and later. For an example deployment of Elasticsearch version 8.x, Kibana 8.x, and an 8.x Enterprise Search server using the Helm chart, refer to the [previous ECK documentation](https://www.elastic.co/guide/en/cloud-on-k8s/2.16/k8s-stack-helm-chart.html).

## Install individual components of the Elastic Stack

You can install individual components in one of two ways using the provided Helm charts:
- Using Helm values with the `eck-stack` chart to include only the components you need
- Using the individual Helm charts directly, without using the `eck-stack` chart

The following examples show how to install only Elasticsearch using each approach.

### Using Helm values to install only Elasticsearch

This example installs only Elasticsearch by deploying the `eck-stack` chart and excluding Kibana. By default, the chart deploys both Elasticsearch and Kibana.
```sh
helm install es-quickstart elastic/eck-stack -n elastic-stack --create-namespace --set=eck-kibana.enabled=false
```


### Using the eck-elasticsearch Helm chart directly to install only Elasticsearch

This example installs Elasticsearch by deploying the `eck-elasticsearch` chart on its own.
```sh
helm install es-quickstart elastic/eck-elasticsearch -n elastic-stack --create-namespace
```


## Upgrade or change your Elastic Stack configuration with Helm

To upgrade your Elastic Stack components to a new version or modify the configuration of your existing installation (known as a `release`), use the [`helm upgrade`](https://helm.sh/docs/helm/helm_upgrade/) command.
The `helm upgrade` command requires the following arguments:
- The name of the release to update, which must match the name used with `helm install`.
- The chart name, which must be the same chart used during installation.

<note>
  When running `helm upgrade`, it’s recommended to pass the same values and configuration options that were used during installation, together with any changes you want to apply. This ensures that the resulting configuration matches your expectations and reduces the risk of values reverting to the chart defaults during the upgrade.Helm provides additional options to control how values associated with an existing release are reused or reset during an upgrade. For details, refer to the [`helm upgrade` documentation](https://helm.sh/docs/helm/helm_upgrade/).
</note>

By default, `helm upgrade` uses the latest available version of the chart unless the `--version` option is specified. Refer to [View chart versions](#show-versions) to list the available chart versions or the version associated with an installed release.
<admonition title="Chart version vs Elastic Stack component version">
  There is an important distinction between the Helm chart version and the Elastic Stack component version:
  - **Chart version**: The version of the Helm chart itself (for example, `eck-stack` version 0.17.0). You can specify this using the `--version` flag in your Helm `install` or `upgrade` commands.
  - **Component version**: The version of a Elastic Stack component (for example, Elasticsearch 9.3.0 or Kibana 9.3.0). You can specify this in your values file or by using `--set` parameters.
  Each chart version defines default Elastic Stack component versions. Unless explicitly overridden, installing or upgrading the chart deploys those default versions.
</admonition>

All examples in this section assume that your release was installed using the `eck-stack` Helm chart. Adapt the examples if you deployed the [individual charts](#k8s-eck-stack-individual-components) directly.

### Upgrade to the latest version of the chart

To upgrade an installed release named `es-kb-quickstart` to the latest version of the Helm chart, do the following:
```sh
helm repo update 
helm upgrade es-kb-quickstart elastic/eck-stack -n elastic-stack
```

By default, upgrading the Helm chart also upgrades the Elastic Stack components to the versions associated with that chart version. To override this behavior, you can explicitly set the Elastic Stack component versions to use, as shown in the following section.

### Upgrade to specific Elastic Stack version

If you want to upgrade the Elastic Stack components to a later version that is not the default for the Helm chart, or you want to update your Helm chart without upgrading the Elastic Stack, you can explicitly set the component versions using Helm values or `--set` options.
The following examples show both ways to upgrade the release to the latest available version of the Helm chart and all Elastic Stack components to version 9.3.0.

#### Using the `--set` option

Use `--set` options to override the component versions directly from the command line:
```sh
helm repo update 
helm upgrade es-kb-quickstart elastic/eck-stack -n elastic-stack \
  --set eck-elasticsearch.version=9.3.0 \ 
  --set eck-kibana.version=9.3.0
```


#### Using a values file

If you already use a values file for this release, update it to include the following settings. Otherwise, create a new values file (for example, `custom-values.yaml`) with the following content:
```yaml
eck-elasticsearch: 
  version: 9.3.0
eck-kibana:
  version: 9.3.0
```

Then upgrade the release using the values file:
```sh
helm repo update 
helm upgrade es-kb-quickstart elastic/eck-stack -n elastic-stack -f custom-values.yaml
```


### Apply configuration changes

To apply configuration changes to an existing release, run `helm upgrade` with the complete configuration you want the release to use. This includes both the current configuration and any new changes.
For example, if you installed the [quickstart release](#k8s-install-elasticsearch-kibana-helm) and want to scale the Elasticsearch cluster to three nodes and expose the Kibana service using a LoadBalancer, do the following:
1. Create a values file with the desired configuration, and save it as `custom-values.yaml`:
   ```yaml
   eck-elasticsearch:
     nodeSets:
     - name: default
       count: 3

   eck-kibana:
     http:
       service:
         spec:
           # This deploys a load balancer in a cloud service provider, where supported.
           type: LoadBalancer
   ```
2. Apply the configuration using `helm upgrade`:
   ```sh
   helm upgrade es-kb-quickstart elastic/eck-stack \
     -n elastic-stack \
     -f custom-values.yaml
   ```

<warning>
  This example also upgrades the Elastic Stack components if a newer Helm chart version is available. To avoid this, [identify the chart version](#show-versions) currently used by your release and include the `--version` option when running `helm upgrade`.
</warning>


## Add Ingress to the Elastic Stack

<admonition title="Support scope for Ingress Controllers">
  [Ingress](https://kubernetes.io/docs/concepts/services-networking/ingress/) is a standard Kubernetes concept. While ECK-managed workloads can be publicly exposed using ingress resources, and we provide [example configurations](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/recipes), setting up an Ingress controller requires in-house Kubernetes expertise.If ingress configuration is challenging or unsupported in your environment, consider using standard `LoadBalancer` services as a simpler alternative.
</admonition>

Both Elasticsearch and Kibana support [Ingress](https://kubernetes.io/docs/concepts/services-networking/ingress/), which can be enabled using the following options:
**If an individual chart is used (not eck-stack)**
The following command installs an Elasticsearch cluster using the `eck-elasticsearch` chart and configures an ingress resource:
```sh
helm install es-quickstart elastic/eck-elasticsearch -n elastic-stack --create-namespace \
  --set=ingress.enabled=true --set=ingress.hosts[0].host=elasticsearch.example.com --set=ingress.hosts[0].path="/"
```

**If eck-stack chart is used**
The following command deploys the basic Elasticsearch and Kibana example with ingress resources for both components:
```sh
helm install es-kb-quickstart elastic/eck-stack -n elastic-stack --create-namespace \
  --set=eck-elasticsearch.ingress.enabled=true --set=eck-elasticsearch.ingress.hosts[0].host=elasticsearch.example.com --set=eck-elasticsearch.ingress.hosts[0].path="/" \
  --set=eck-kibana.ingress.enabled=true --set=eck-kibana.ingress.hosts[0].host=kibana.example.com --set=eck-kibana.ingress.hosts[0].path="/"
```

For illustration purposes, the ingress objects created by the previous command look similar to the following:
```yaml
# Source: eck-stack/charts/eck-elasticsearch/templates/ingress.yaml
apiVersion: networking.k8s.io/v1
kind: Ingress
metadata:
  name: elasticsearch
  labels:
    ...
spec:
  rules:
  - host: "elasticsearch.example.com"
    http:
      paths:
      - path: /
        pathType: Prefix
        backend:
          service:
            name: elasticsearch-es-http
            port:
              number: 9200
---
# Source: eck-stack/charts/eck-kibana/templates/ingress.yaml
apiVersion: networking.k8s.io/v1
kind: Ingress
metadata:
  name: es-kb-quickstart-eck-kibana
  labels:
    ...
spec:
  rules:
  - host: "kibana.example.com"
    http:
      paths:
      - path: /
        pathType: Prefix
        backend:
          service:
            name: es-kb-quickstart-eck-kibana-kb-http
            port:
              number: 5601
```


## View available configuration options

You can view all configurable values of the Elastic Stack helm chart of the individual charts by running the following:
```sh
helm show values elastic/eck-stack
helm show values elastic/eck-elasticsearch
helm show values elastic/eck-kibana
helm show values elastic/eck-agent
helm show values elastic/eck-beats
helm show values elastic/eck-apm-server
helm show values elastic/eck-fleet-server
helm show values elastic/eck-logstash
helm show values elastic/eck-package-registry
```


## View available chart versions

To view the available versions of a Helm chart, update the local chart cache and use the `helm repo search` command with `--versions` option. You can use this flag with `eck-stack` or [individual charts](#k8s-eck-stack-individual-components).
```sh
helm repo update
helm repo search elastic/eck-stack --versions
```

To view the version associated with an installed release, check the **CHART** column of the `helm list` command output. For example:
```sh
$ helm list -n elastic-stack
NAME            	NAMESPACE    	REVISION	UPDATED                             	STATUS  	CHART                   	APP VERSION
es-kb-quickstart	elastic-stack	2       	2025-12-17 11:24:06.156007 +0100 CET	deployed	eck-stack-0.17.0
```