﻿---
title: Manage deployments in Elastic Cloud on Kubernetes
description: This section provides detailed guidance on deploying, configuring, and managing Elasticsearch and Kibana within ECK. A deployment refers to an Elasticsearch...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/manage-deployments
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Manage deployments in Elastic Cloud on Kubernetes
This section provides detailed guidance on deploying, configuring, and managing Elasticsearch and Kibana within ECK. A **deployment** refers to an Elasticsearch cluster, optionally with one or more Kibana instances connected to it.
<tip>
  This content focuses on Elasticsearch and Kibana deployments. To orchestrate other Elastic Stack applications such as APM Server, Beats, Elastic Agent, Elastic Maps Server, and Logstash, refer to the [Orchestrating other Elastic Stack applications](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/orchestrate-other-elastic-applications).
</tip>


## What You'll Learn

In this section, you'll learn how to perform the following tasks in ECK:
- [**Deploy an Elasticsearch cluster**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-deployment-quickstart): Orchestrate an Elasticsearch cluster in Kubernetes.
- [**Deploy Kibana instances**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/kibana-instance-quickstart): Set up and connect Kibana to an existing Elasticsearch cluster.
- [**Manage deployments using Elastic Stack Helm chart**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/managing-deployments-using-helm-chart): Use Helm to deploy clusters and other stack applications.
- [**Apply updates to your deployments**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/update-deployments): Modify existing deployments, scale clusters, and update configurations, while ensuring minimal disruption.
- [**Configure access to your deployments**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/accessing-services): Use and adapt Kubernetes services to your needs.
- [**Advanced configuration**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-deployments): Explore available settings for Elasticsearch and Kibana, including storage, networking, security, and scaling options.

For a complete reference on configuration possibilities for Elasticsearch and Kibana, see:
- [Elasticsearch configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-configuration)
- [Kibana configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/kibana-configuration)

Other references for managing deployments:
- [**Upgrade the Elastic Stack version**](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster): Upgrade orchestrated applications on ECK.