﻿---
title: Logstash
description: This section describes how to configure and deploy Logstash with ECK. Quickstart, Configuration, Securing Logstash API, Logstash plugins, Configuration...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/logstash
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Logstash
This section describes how to configure and deploy Logstash with ECK.
- [Quickstart](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/quickstart-logstash)
- [Configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configuration-logstash)
  - [Logstash configuration](/docs/deploy-manage/deploy/cloud-on-k8s/configuration-logstash#k8s-logstash-configuring-logstash)
- [Configuring Logstash pipelines](/docs/deploy-manage/deploy/cloud-on-k8s/configuration-logstash#k8s-logstash-pipelines)
- [Defining data volumes for Logstash](/docs/deploy-manage/deploy/cloud-on-k8s/configuration-logstash#k8s-logstash-volumes)
- [Using Elasticsearch in Logstash pipelines](/docs/deploy-manage/deploy/cloud-on-k8s/configuration-logstash#k8s-logstash-pipelines-es)
- [Expose services](/docs/deploy-manage/deploy/cloud-on-k8s/configuration-logstash#k8s-logstash-expose-services)
- [Securing Logstash API](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/securing-logstash-api)
- [Logstash plugins](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/logstash-plugins)
  - [Providing additional resources for plugins](/docs/deploy-manage/deploy/cloud-on-k8s/logstash-plugins#k8s-plugin-resources)
- [Scaling Logstash on ECK](/docs/deploy-manage/deploy/cloud-on-k8s/logstash-plugins#k8s-logstash-working-with-plugins-scaling)
- [Plugin-specific considerations](/docs/deploy-manage/deploy/cloud-on-k8s/logstash-plugins#k8s-logstash-working-with-plugin-considerations)
- [Adding custom plugins](/docs/deploy-manage/deploy/cloud-on-k8s/logstash-plugins#k8s-logstash-working-with-custom-plugins)
- [Configuration examples](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configuration-examples-logstash)
- [Update Strategy](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/update-strategy-logstash)
- [Advanced configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/advanced-configuration-logstash)
  - [Setting JVM options](/docs/deploy-manage/deploy/cloud-on-k8s/advanced-configuration-logstash#k8s-logstash-jvm-options)
- [Setting keystore](/docs/deploy-manage/deploy/cloud-on-k8s/advanced-configuration-logstash#k8s-logstash-keystore)

<note>
  Running Logstash on ECK is compatible only with Logstash 8.7+.
</note>