﻿---
title: Known limitations
description: Until version 7.14.0 and ECK version 2.10.0, Elastic Agent and Fleet Server were required to run as root. As of Elastic Stack version 7.14.0 and ECK version...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/known-limitations
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Known limitations
## Running as root (ECK < 2.10.0 and Agent < 7.14.0)

Until version 7.14.0 and ECK version 2.10.0, Elastic Agent and Fleet Server were required to run as root.
As of Elastic Stack version 7.14.0 and ECK version 2.10.0 it is also possible to run Elastic Agent and Fleet as a non-root user. See [Storing local state in host path volume](/docs/deploy-manage/deploy/cloud-on-k8s/configuration-examples-standalone#k8s_storing_local_state_in_host_path_volume) for instructions.

## Elastic Agent running in the same namespace as the Elastic Stack.

Until ECK version 2.11.0, Elastic Agent and Fleet Server were required to run within the same Namespace as Elasticsearch.
As of ECK version 2.11.0, Elastic Agent, Fleet Server and Elasticsearch can all be deployed in different Namespaces.

## Running Endpoint Security integration

Running Endpoint Security [integration](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend) is not yet supported in containerized environments, like Kubernetes. This is not an ECK limitation, but the limitation of the integration itself. Note that you can use ECK to deploy Elasticsearch, Kibana and Fleet Server, and add Endpoint Security integration to your policies if Elastic Agents running those policies are deployed in non-containerized environments.

## Fleet Server initialization fails on minikube when CNI is disabled

When deployed with ECK, the Fleet Server Pod makes an HTTP call to itself during Fleet initialization using its Service. Since a [Pod cannot reach itself through its Service on minikube](https://github.com/kubernetes/minikube/issues/1568) when CNI is disabled, the call hangs until the connection times out and the Pod enters a crash loop.
Solution: enable CNI when starting minikube: `minikube start --cni=true`.

## Storing local state in host path volume

Elastic Agent managed by ECK stores local state in a host path volume by default. This ensures that Integrations run by the agent can continue their work without duplicating work that has already been done after the Pod has been recreated for example because of a Pod configuration change. Multiple replicas of an agent, for example Fleet Servers, can not be deployed on the same underlying Kubernetes node as they would try to use the same host path. There are 2 options for managing this feature:
1. If local state storage in `hostPath` volumes is not desired this can be turned off by configuring an `emptyDir` volume instead.
2. If local state storage is still desired but running the Agent container as root is not allowed, then you can run a `DaemonSet` that adjusts the permissions for the Agent local state on each Node prior to running Elastic Agent. Note that this `DaemonSet` must be `runAsUser: 0` and possibly `privileged: true`. Also note the Kibana changes required to trust the Elasticsearch CA when running in fleet mode.

Full configuration examples exist in  [Running as a non-root user](/docs/deploy-manage/deploy/cloud-on-k8s/configuration-fleet#k8s-elastic-agent-running-as-a-non-root-user).