﻿---
title: Deploy a Kibana instance
description: To deploy a simple Kibana specification, with one Kibana instance: Specify a Kibana instance and associate it with your Elasticsearch quickstart cluster...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/kibana-instance-quickstart
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Deploy a Kibana instance
To deploy a simple [Kibana](/docs/get-started/the-stack#stack-components-kibana) specification, with one Kibana instance:
1. Specify a Kibana instance and associate it with your Elasticsearch `quickstart` cluster created previously under [Deploying an Elasticsearch cluster](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-deployment-quickstart):
   ```yaml
   cat <<EOF | kubectl apply -f -
   apiVersion: kibana.k8s.elastic.co/v1
   kind: Kibana
   metadata:
     name: quickstart
   spec:
     version: 9.3.0
     count: 1
     elasticsearchRef:
       name: quickstart
   EOF
   ```
2. Monitor Kibana health and creation progress.
   Similar to Elasticsearch, you can retrieve details about Kibana instances with [`get`](https://kubernetes.io/docs/reference/kubectl/generated/kubectl_get/):
   ```sh
   kubectl get kibana
   ```
   And the associated Pods:
   ```sh
   kubectl get pod --selector='kibana.k8s.elastic.co/name=quickstart'
   ```
   Kibana will be status `available` once [`get`](https://kubernetes.io/docs/reference/kubectl/generated/kubectl_get/) reports `green`. If it experiences issues starting up, use [`logs`](https://kubernetes.io/docs/reference/kubectl/generated/kubectl_logs/) against the pod in order to make sure the Kibana server is [ready](https://www.elastic.co/docs/troubleshoot/kibana/error-server-not-ready).
3. Access Kibana.
   A `ClusterIP` Service is automatically created for Kibana:
   ```sh
   kubectl get service quickstart-kb-http
   ```
   Use `kubectl port-forward` to access Kibana from your local workstation:
   ```sh
   kubectl port-forward service/quickstart-kb-http 5601
   ```
   Open `https://localhost:5601` in your browser. Your browser will show a warning because the self-signed certificate configured by default is not verified by a known certificate authority and not trusted by your browser. You can temporarily acknowledge the warning for the purposes of this quick start but it is highly recommended that you [configure valid certificates](/docs/deploy-manage/security/k8s-https-settings#k8s-setting-up-your-own-certificate) for any production deployments.
   Login as the `elastic` user. The password can be obtained with the following command:
   ```sh
   kubectl get secret quickstart-es-elastic-user -o=jsonpath='{.data.elastic}' | base64 --decode; echo
   ```

For a full description of each `CustomResourceDefinition` (CRD), refer to the [API reference](https://www.elastic.co/docs/reference/cloud-on-k8s/api-docs) or view the CRD files in the [project repository](https://github.com/elastic/cloud-on-k8s/tree/3.3/config/crds). You can also retrieve information about a CRD from the instance. For example, describe the Kibana CRD specification with [`describe`](https://kubernetes.io/docs/reference/kubectl/generated/kubectl_describe/):
```sh
kubectl describe crd kibana
```


## Next steps

This completes the quickstart of deploying an Kibana instance on top of [the ECK operator](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/install-using-yaml-manifest-quickstart) and [deployed Elasticsearch cluster](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-deployment-quickstart).
We recommend continuing to:
- [Updating your deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/update-deployments).
- For more Kibana configuration options, refer to [Kibana configuration on ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/kibana-configuration) and [Configure deployments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-deployments).