﻿---
title: Kibana configuration
description: The following sections describe how to customize a Kibana deployment to suit your requirements. Connect to an Elasticsearch cluster, Advanced configuration,...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/kibana-configuration
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Kibana configuration
The following sections describe how to customize a Kibana deployment to suit your requirements.
- [Connect to an Elasticsearch cluster](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-es)
  - [Connect to an Elasticsearch cluster managed by ECK](/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-es#k8s-kibana-eck-managed-es)
- [Connect to an Elasticsearch cluster not managed by ECK](/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-es#k8s-kibana-external-es)
- [Advanced configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-advanced-configuration)
  - [Pod Configuration](/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-advanced-configuration#k8s-kibana-pod-configuration)
- [Kibana Configuration](/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-advanced-configuration#k8s-kibana-configuration)
- [Scaling out a Kibana deployment](/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-advanced-configuration#k8s-kibana-scaling)
- [Secure settings](/docs/deploy-manage/security/k8s-secure-settings#k8s-kibana-secure-settings)
- [HTTP Configuration](/docs/deploy-manage/security/k8s-https-settings#k8s-kibana-http-configuration)
  - [Load balancer settings and TLS SANs](/docs/deploy-manage/security/k8s-https-settings#k8s-kibana-http-publish)
- [Provide your own certificate](/docs/deploy-manage/security/k8s-https-settings#k8s-kibana-http-custom-tls)
- [Disable TLS](/docs/deploy-manage/security/k8s-https-settings#k8s-disable-tls)
- [Install Kibana plugins](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-plugins)
- [Autoscaling stateless applications](/docs/deploy-manage/autoscaling/autoscaling-in-eck#k8s-stateless-autoscaling): Use [Horizontal Pod Autoscaler](https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/) for Kibana or other stateless applications.