﻿---
title: Deploy the operator
description: This page shows the installation steps to deploy ECK in Openshift: Apply the manifests the same way as described in Install ECK using the YAML manifests...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-openshift-deploy-operator
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Deploy the operator
<note>
  These instructions do not apply if the operator is installed from the OpenShift software catalog or when using Operator Lifecycle Manager (OLM). However, creating resources outside of the installation namespace, as mentioned in step 3, is always advised.
</note>

This page shows the installation steps to deploy ECK in Openshift:
1. Apply the manifests the same way as described in [Install ECK using the YAML manifests](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/install-using-yaml-manifest-quickstart) document:
   ```shell
   oc create -f https://download.elastic.co/downloads/eck/3.3.0/crds.yaml
   oc apply -f https://download.elastic.co/downloads/eck/3.3.0/operator.yaml
   ```
2. [Optional] If the Software Defined Network is configured with the `ovs-multitenant` plug-in, you must allow the `elastic-system` namespace to access other Pods and Services in the cluster:
   ```shell
   oc adm pod-network make-projects-global elastic-system
   ```
3. Create a namespace to hold the Elastic resources (Elasticsearch, Kibana, APM Server, Beats, Elastic Agent, Elastic Maps Server, and Logstash):
   <note>
   A namespace other than the default namespaces (default, kube-*, openshift-*, etc) is required such that default [Security Context Constraint](https://docs.openshift.com/container-platform/4.12/authentication/managing-security-context-constraints.html) (SCC) permissions are applied automatically. Elastic resources will not work properly in any of the default namespaces.
   </note>
   ```sh
   oc new-project elastic
   ```
4. [Optional] Allow another user or a group of users to manage the Elastic resources:
   ```shell
   oc adm policy add-role-to-user elastic-operator developer -n elastic
   ```
   In this example the user `developer` is allowed to manage Elastic resources in the namespace `elastic`.