﻿---
title: Deploy a Kibana instance with a route
description: Use the following code to create a Kibana instance and a "passthrough" route to access it: Use the following command to get the hosts of each Route: 
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-openshift-deploy-kibana
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Deploy a Kibana instance with a route
Use the following code to create a Kibana instance and a "passthrough" route to access it:
```shell
cat <<EOF | oc apply -n elastic -f -
apiVersion: kibana.k8s.elastic.co/v1
kind: Kibana
metadata:
  name: kibana-sample
spec:
  version: 9.3.0
  count: 1
  elasticsearchRef:
    name: "elasticsearch-sample"
  podTemplate:
    spec:
      containers:
      - name: kibana
        resources:
          limits:
            memory: 1Gi
            cpu: 1
---
apiVersion: route.openshift.io/v1
kind: Route
metadata:
  name: kibana-sample
spec:
  #host: kibana.example.com
  tls:
    termination: passthrough
    insecureEdgeTerminationPolicy: Redirect
  to:
    kind: Service
    name: kibana-sample-kb-http
EOF
```

Use the following command to get the hosts of each `Route`:
```shell
oc get route -n elastic
```