﻿---
title: Deploy an Elasticsearch instance with a route
description: Use the following code to create an Elasticsearch cluster elasticsearch-sample and a "passthrough" route to access it: Elasticsearch plugins cannot be...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-openshift-deploy-elasticsearch
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Deploy an Elasticsearch instance with a route
Use the following code to create an Elasticsearch cluster `elasticsearch-sample` and a "passthrough" route to access it:
<note>
  A namespace other than the default namespaces (default, kube-system, kube-**, openshift-**, etc) is required such that default [Security Context Constraint](https://docs.openshift.com/container-platform/4.12/authentication/managing-security-context-constraints.html) (SCC) permissions are applied automatically. Elastic resources will not work properly in any of the default namespaces.
</note>

```shell
cat <<EOF | oc apply -n elastic -f -
# This sample sets up an Elasticsearch cluster with an OpenShift route
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
metadata:
  name: elasticsearch-sample
spec:
  version: 9.3.0
  nodeSets:
  - name: default
    count: 1
    config:
      node.store.allow_mmap: false
---
apiVersion: route.openshift.io/v1
kind: Route
metadata:
  name: elasticsearch-sample
spec:
  #host: elasticsearch.example.com
  tls:
    termination: passthrough
    insecureEdgeTerminationPolicy: Redirect
  to:
    kind: Service
    name: elasticsearch-sample-es-http
EOF
```


## Elasticsearch plugins

Elasticsearch plugins cannot be installed at runtime in most OpenShift environments. This is because the plugin installer must run as root, but Elasticsearch is restricted from running as root. To add plugins to Elasticsearch, you can use custom images as described in [*Create custom images*](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/create-custom-images).