﻿---
title: Deploy Docker images with anyuid SCC
description: Starting with Elastic Stack version 7.9, it is possible to run the APM Server with the restricted SCC. For APM versions older than 7.9, you can use this...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-openshift-anyuid-workaround
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Deploy Docker images with anyuid SCC
Starting with Elastic Stack version 7.9, it is possible to run the APM Server with the `restricted` SCC. For APM versions older than 7.9, you can use this workaround which allows the Pod to run with the default `uid 1000` by assigning it to the `anyuid` SCC:
1. Create a service account to run the APM Server:
   ```shell
   oc create serviceaccount apm-server -n elastic
   ```
2. Add the APM service account to the `anyuid` SCC:
   ```shell
   oc adm policy add-scc-to-user anyuid -z apm-server -n elastic
   ```
   ```shell
   scc "anyuid" added to: ["system:serviceaccount:elastic:apm-server"]
   ```
3. Deploy an APM Server and a `Route` with the following manifest:
   
   ```shell
   cat <<EOF | oc apply -n elastic -f -
   apiVersion: apm.k8s.elastic.co/v1
   kind: ApmServer
   metadata:
     name: apm-server-sample
   spec:
     version: 9.3.0
     count: 1
     elasticsearchRef:
       name: "elasticsearch-sample"
     podTemplate:
       spec:
         serviceAccountName: apm-server
   ---
   apiVersion: route.openshift.io/v1
   kind: Route
   metadata:
     name: apm-server-sample
   spec:
     #host: apm-server.example.com
     tls:
       termination: passthrough
       insecureEdgeTerminationPolicy: Redirect
     to:
       kind: Service
       name: apm-server-sample-apm-http
   EOF
   ```
   To check that the Pod of the APM Server is using the correct SCC, use the following command:
   ```shell
   oc get pod -o go-template='{{range .items}}{{$scc := index .metadata.annotations "openshift.io/scc"}}{{.metadata.name}}{{" scc:"}}{{range .spec.containers}}{{$scc}}{{" "}}{{"\n"}}{{end}}{{end}}'
   ```
   ```shell
   apm-server-sample-apm-server-86bfc5c95c-96lbx scc:anyuid
   elasticsearch-sample-es-5tsqghmm79 scc:restricted
   elasticsearch-sample-es-6qk52mz5jk scc:restricted
   elasticsearch-sample-es-dg4vvpm2mr scc:restricted
   kibana-sample-kb-97c6b6b8d-lqfd2 scc:restricted
   ```

<important>
  Enterprise Search is not available in versions 9.0+.
</important>