﻿---
title: Install Kibana plugins
description: You can override the Kibana container image to use your own image with the plugins already installed, as described in the Create custom images. You should...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-plugins
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Install Kibana plugins
You can override the Kibana container image to use your own image with the plugins already installed, as described in the [Create custom images](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/create-custom-images). You should run an `optimize` step as part of the build, otherwise it needs to run at startup which requires additional time and resources.
This is a Dockerfile example:
```sh
FROM docker.elastic.co/kibana/kibana:9.3.0
RUN /usr/share/kibana/bin/kibana-plugin install $PLUGIN_URL
RUN /usr/share/kibana/bin/kibana --optimize
```