﻿---
title: Connect to an Elasticsearch cluster
description: You can connect an Elasticsearch cluster that is either managed by ECK or not managed by ECK. It is quite straightforward to connect a Kibana instance...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-es
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Connect to an Elasticsearch cluster
You can connect an Elasticsearch cluster that is either managed by ECK or not managed by ECK.

## Elasticsearch is managed by ECK

It is quite straightforward to connect a Kibana instance to an Elasticsearch cluster managed by ECK:
```yaml
apiVersion: kibana.k8s.elastic.co/v1
kind: Kibana
metadata:
  name: quickstart
spec:
  version: 9.3.0
  count: 1
  elasticsearchRef:
    name: quickstart
    namespace: default
```

The use of `namespace` is optional if the Elasticsearch cluster is running in the same namespace as Kibana. An additional `serviceName` attribute can be specified to target a custom Kubernetes service. Refer to [*Traffic Splitting*](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/requests-routing-to-elasticsearch-nodes) for more information. The Kibana configuration file is automatically setup by ECK to establish a secure connection to Elasticsearch.
<note>
  Any Kibana can reference (and thus access) any Elasticsearch instance as long as they are both in namespaces that are watched by the same ECK instance. ECK will copy the required Secret from Elasticsearch to Kibana namespace. Kibana cannot automatically connect to Elasticsearch (through `elasticsearchRef`) in a namespace managed by a different ECK instance. For more information, check [Restrict cross-namespace resource associations](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/restrict-cross-namespace-resource-associations).
</note>


## Elasticsearch is not managed by ECK

You can also configure Kibana to connect to an Elasticsearch cluster that is managed by a different installation of ECK, or runs outside the Kubernetes cluster. In this case, you need the IP address or URL of the Elasticsearch cluster and a valid username and password pair to access the cluster.

## Using a Secret

Refer to [*Connect to external Elastic resources*](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/connect-to-external-elastic-resources) to automatically configure Kibana using connection settings from a [`Secret`](https://kubernetes.io/docs/concepts/configuration/secret/).

## Using secure settings

For example, use the [secure settings](https://www.elastic.co/docs/deploy-manage/security/k8s-secure-settings) mechanism to securely store the default `elastic` user’s `$PASSWORD` credential of the external Elasticsearch cluster as set under [Deploy an Elasticsearch cluster](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-deployment-quickstart):
```shell
kubectl create secret generic kibana-elasticsearch-credentials --from-literal=elasticsearch.password=$PASSWORD
```

```yaml
apiVersion: kibana.k8s.elastic.co/v1
kind: Kibana
metadata:
  name: kibana-sample
spec:
  version: 9.3.0
  count: 1
  config:
    elasticsearch.hosts:
      - <ELASTICSEARCH_HOST_URL>:9200
    elasticsearch.username: elastic
  secureSettings:
    - secretName: kibana-elasticsearch-credentials
```

If the external Elasticsearch cluster is using a self-signed certificate, create a [`Secret`](https://kubernetes.io/docs/concepts/configuration/secret/) containing the CA certificate and mount it to the Kibana container as follows:
```yaml
apiVersion: kibana.k8s.elastic.co/v1
kind: Kibana
metadata:
  name: kibana-sample
spec:
  version: 9.3.0
  count: 1
  config:
    elasticsearch.hosts:
      - <ELASTICSEARCH_HOST_URL>-es-http:9200
    elasticsearch.username: elastic
    elasticsearch.ssl.certificateAuthorities: /etc/certs/ca.crt
  secureSettings:
    - secretName: kibana-elasticsearch-credentials
  podTemplate:
    spec:
      volumes:
        - name: elasticsearch-certs
          secret:
            secretName: elasticsearch-certs-secret
      containers:
        - name: kibana
          volumeMounts:
            - name: elasticsearch-certs
              mountPath: /etc/certs
              readOnly: true
```