﻿---
title: Advanced Kibana deployment and configuration on Elastic Cloud on Kubernetes
description: If you already looked at the Elasticsearch on ECK documentation, some of these concepts might sound familiar to you. The resource definitions in ECK share...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-advanced-configuration
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Advanced Kibana deployment and configuration on Elastic Cloud on Kubernetes
If you already looked at the [Elasticsearch on ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-configuration) documentation, some of these concepts might sound familiar to you. The resource definitions in ECK share the same philosophy when you want to:
- [Customize the Pod configuration](#k8s-kibana-pod-configuration)
- [Customize the product configuration](#k8s-kibana-configuration)
- [Manage HTTP settings](/docs/deploy-manage/security/k8s-https-settings#k8s-kibana-http-configuration)
- [Use secure settings](https://www.elastic.co/docs/deploy-manage/security/k8s-secure-settings)
- [Install Kibana plugins](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-plugins)


## Pod configuration

You can [customize the Kibana Pod](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/customize-pods) using a [Pod Template](https://kubernetes.io/docs/concepts/workloads/pods/#pod-templates).
The following example demonstrates how to create a Kibana deployment with custom node affinity, increased heap size, and resource limits.
```yaml
apiVersion: kibana.k8s.elastic.co/v1
kind: Kibana
metadata:
  name: kibana-sample
spec:
  version: 9.3.0
  count: 1
  elasticsearchRef:
    name: "elasticsearch-sample"
  podTemplate:
    spec:
      containers:
      - name: kibana
        env:
          - name: NODE_OPTIONS
            value: "--max-old-space-size=2048"
        resources:
          requests:
            memory: 1Gi
            cpu: 0.5
          limits:
            memory: 2.5Gi
            cpu: 2
      nodeSelector:
        type: frontend
```

The name of the container in the [Pod Template](https://kubernetes.io/docs/concepts/workloads/pods/#pod-templates) must be `kibana`.
Check [Set compute resources for Kibana, Elastic Maps Server, APM Server and Logstash](/docs/deploy-manage/deploy/cloud-on-k8s/manage-compute-resources#k8s-compute-resources-kibana-and-apm) for more information.

## Kibana configuration

You can add your own Kibana settings to the `spec.config` section.
The following example demonstrates how to set the [`elasticsearch.requestHeadersWhitelist`](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#elasticsearch-requestheaderswhitelist) configuration option.
```yaml
apiVersion: kibana.k8s.elastic.co/v1
kind: Kibana
metadata:
  name: kibana-sample
spec:
  version: 9.3.0
  count: 1
  elasticsearchRef:
    name: "elasticsearch-sample"
  config:
     elasticsearch.requestHeadersWhitelist:
     - authorization
```


## Scale out a Kibana deployment

To deploy more than one instance of Kibana, the instances must share a matching set of encryption keys. The following keys are automatically generated by the operator:
- [`xpack.security.encryptionKey`](https://www.elastic.co/docs/reference/kibana/configuration-reference/security-settings#xpack-security-encryptionkey)
- [`xpack.reporting.encryptionKey`](https://www.elastic.co/docs/reference/kibana/configuration-reference/reporting-settings#encryption-keys)
- [`xpack.encryptedSavedObjects.encryptionKey`](https://www.elastic.co/docs/deploy-manage/security/secure-saved-objects)

<tip>
  If you need to access these encryption keys, you can find them using the `kubectl get secrets` command.The secret is named after the corresponding Kibana instance. For example, for a Kibana named `my-kibana`, you can run the following command to retrieve the current encryption keys:
  ```shell
  kubectl get secret my-kibana-kb-config -o jsonpath='{ .data.kibana\.yml }' | base64 --decode | grep -A1 encryptedSavedObjects
  ```
</tip>

You can provide your own encryption keys using a secure setting, as described in [Secure settings](https://www.elastic.co/docs/deploy-manage/security/k8s-secure-settings).
<note>
  While most reconfigurations of your Kibana instances are carried out in rolling upgrade fashion, all version upgrades will cause Kibana downtime. This happens because you can only run a single version of Kibana at any given time. For more information, check [Upgrade Kibana](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster).
</note>