﻿---
title: Install ECK
description: Elastic Cloud on Kubernetes (ECK) is a Kubernetes operator that helps you deploy and manage Elastic applications on Kubernetes, including Elasticsearch,...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/install
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Install ECK
Elastic Cloud on Kubernetes (ECK) is a [Kubernetes operator](https://kubernetes.io/docs/concepts/extend-kubernetes/operator/) that helps you deploy and manage Elastic applications on Kubernetes, including Elasticsearch, Kibana, APM Server, Beats, Elastic Agent, Elastic Maps Server, and Logstash.
ECK relies on a set of [Custom Resource Definitions (CRDs)](https://kubernetes.io/docs/concepts/extend-kubernetes/api-extension/custom-resources/#customresourcedefinitions) to define how applications are deployed. CRDs are global resources, shared across the entire Kubernetes cluster, so installing them requires [specific permissions](/docs/deploy-manage/deploy/cloud-on-k8s/required-rbac-permissions#k8s-eck-permissions-installing-crds).
ECK can be installed in two modes, depending on the namespaces the operator is allowed to manage:
1. **Cluster-wide installation**: Allows the operator to orchestrate applications in all namespaces of the Kubernetes cluster. This is the default installation method.
2. **Namespace-restricted installation**: Limited to specific, pre-defined namespaces. Use the `namespaces` [configuration flag](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-eck) to limit the namespaces in which the operator is allowed to work.

<note>
  You can install multiple instances of ECK in the same Kubernetes cluster, but only if the CRDs are compatible across all operator instances (e.g., by ensuring they run the same version). If running multiple instances, you must also disable cluster-wide features like the [validating webhook](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-validating-webhook).
</note>

<warning>
  Deleting CRDs will trigger deletion of all custom resources (Elasticsearch, Kibana, APM Server, Beats, Elastic Agent, Elastic Maps Server, and Logstash) in all namespaces of the cluster, regardless of whether they are managed by a single operator or multiple operators.
</warning>

For a list of supported Kubernetes versions refer to [Elastic Cloud on Kubernetes > Supported versions](/docs/deploy-manage/deploy/cloud-on-k8s#k8s-supported)

## Installation methods

ECK supports multiple installation methods. Choose the one that best fits your infrastructure:
- [Install ECK using YAML manifests](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/install-using-yaml-manifest-quickstart)
- [Install ECK using a Helm chart](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/install-using-helm-chart)
- [Deploy ECK on Openshift](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/deploy-eck-on-openshift)
- [Deploy ECK on GKE Autopilot](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/deploy-eck-on-gke-autopilot)
- [Deploy ECK on Google Distributed Hosted Cloud](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/eck-gdch)
- [Deploy a FIPS compatible version of ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/deploy-fips-compatible-version-of-eck)

For air-gapped environments, refer to [Running ECK in air-gapped environments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/air-gapped-install) to understand the requirements and installation considerations.
Refer to [Required RBAC permissions](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/required-rbac-permissions) for a complete list of the permissions needed by the operator.
<note>
  To upgrade ECK, refer to [Upgrade Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/upgrade/orchestrator/upgrade-cloud-on-k8s).
</note>