﻿---
title: Init containers for plugin downloads
description: You can install custom plugins before the Elasticsearch container starts with an initContainer. For example: You can also override the Elasticsearch container...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/init-containers-for-plugin-downloads
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Init containers for plugin downloads
You can install custom plugins before the Elasticsearch container starts with an `initContainer`. For example:
```yaml
spec:
  nodeSets:
  - name: default
    count: 3
    podTemplate:
      spec:
        initContainers:
        - name: install-plugins
          command:
          - sh
          - -c
          - |
            bin/elasticsearch-plugin remove --purge analysis-icu
            bin/elasticsearch-plugin install --batch analysis-icu
```

You can also override the Elasticsearch container image to use your own image with the plugins already installed, as described in [custom images](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/create-custom-images). For more information on both these options, you can check the [Create automated snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-on-k8s) section and the Kubernetes documentation on [init containers](https://kubernetes.io/docs/concepts/workloads/pods/init-containers/).
The init container inherits:
- The image of the main container image, if one is not explicitly set.
- The volume mounts from the main container unless a volume mount with the same name and mount path is present in the init container definition
- The Pod name and IP address environment variables.