﻿---
title: Deploy an Elasticsearch cluster
description: To deploy a simple Elasticsearch cluster specification, with one Elasticsearch node: The operator automatically creates and manages Kubernetes resources...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-deployment-quickstart
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Deploy an Elasticsearch cluster
To deploy a simple [Elasticsearch](https://www.elastic.co/docs/solutions/search/get-started) cluster specification, with one Elasticsearch node:
```yaml
cat <<EOF | kubectl apply -f -
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
metadata:
  name: quickstart
spec:
  version: 9.3.0
  nodeSets:
  - name: default
    count: 1
    config:
      node.store.allow_mmap: false
EOF
```

The operator automatically creates and manages Kubernetes resources to achieve the desired state of the Elasticsearch cluster. It may take up to a few minutes until all the resources are created and the cluster is ready for use.
<warning>
  Setting `node.store.allow_mmap: false` has performance implications and should be tuned for production workloads as described in the [Virtual memory](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/virtual-memory) section.
</warning>

<note>
  If your Kubernetes cluster does not have any Kubernetes nodes with at least 2GiB of free memory, the pod will be stuck in `Pending` state. Check [*Manage compute resources*](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/manage-compute-resources) for more information about resource requirements and how to configure them.
</note>

<note>
  The cluster that you deployed in this quickstart guide only allocates a persistent volume of 1GiB for storage using the default [storage class](https://kubernetes.io/docs/concepts/storage/storage-classes/) defined for the Kubernetes cluster. You will most likely want to have more control over this for production workloads. Refer to [Volume claim templates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/volume-claim-templates) for more information.
</note>

For a full description of each `CustomResourceDefinition` (CRD), refer to the [*API Reference*](https://www.elastic.co/docs/reference/cloud-on-k8s/api-docs) or view the CRD files in the [project repository](https://github.com/elastic/cloud-on-k8s/tree/3.3/config/crds). You can also retrieve information about a CRD from the cluster. For example, describe the Elasticsearch CRD specification with [`describe`](https://kubernetes.io/docs/reference/kubectl/generated/kubectl_describe/):
```sh
kubectl describe crd elasticsearch
```


## Monitor cluster health and creation progress

Get an overview of the current Elasticsearch clusters in the Kubernetes cluster with [`get`](https://kubernetes.io/docs/reference/kubectl/generated/kubectl_get/), including health, version and number of nodes:
```sh
kubectl get elasticsearch
```

When you first create the Kubernetes cluster, there is no `HEALTH` status and the `PHASE` is empty. After the pod and service start-up, the `PHASE` turns into `Ready`, and `HEALTH` becomes `green`. The `HEALTH` status comes from Elasticsearch's [cluster health API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-health).
```sh
NAME          HEALTH    NODES     VERSION   PHASE         AGE
quickstart              1         9.3.0               1s
```

While the Elasticsearch pod is in the process of being started it will report `Pending` as checked with [`get`](https://kubernetes.io/docs/reference/kubectl/generated/kubectl_get/):
```sh
kubectl get pods --selector='elasticsearch.k8s.elastic.co/cluster-name=quickstart'
```

Which will output similar to:
```sh
NAME                      READY   STATUS    RESTARTS   AGE
quickstart-es-default-0   0/1     Pending   0          9s
```

During and after start-up, up that pod’s [`logs`](https://kubernetes.io/docs/reference/kubectl/generated/kubectl_logs/) can be accessed:
```sh
kubectl logs -f quickstart-es-default-0
```

Once the pod has finished coming up, our original [`get`](https://kubernetes.io/docs/reference/kubectl/generated/kubectl_get/) request will now report:
```sh
NAME          HEALTH    NODES     VERSION   PHASE         AGE
quickstart    green     1         9.3.0     Ready         1m
```


## Request Elasticsearch access

A `ClusterIP` Service is automatically created for your cluster as checked with [`get`](https://kubernetes.io/docs/reference/kubectl/generated/kubectl_get/):
```sh
kubectl get service quickstart-es-http
```

Which will output similar to:
```sh
NAME                 TYPE        CLUSTER-IP      EXTERNAL-IP   PORT(S)    AGE
quickstart-es-http   ClusterIP   10.15.251.145   <none>        9200/TCP   34m
```

In order to make requests to the [Elasticsearch API](https://www.elastic.co/docs/reference/elasticsearch/rest-apis):
1. Get the credentials.
   By default, a user named `elastic` is created with the password stored inside a [Kubernetes secret](https://kubernetes.io/docs/concepts/configuration/secret/). This default user can be disabled if desired, refer to [Users and roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native) for more information.
   ```sh
   PASSWORD=$(kubectl get secret quickstart-es-elastic-user -o go-template='{{.data.elastic | base64decode}}')
   ```
2. Request the [Elasticsearch root API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-info). You can do so from inside the Kubernetes cluster or from your local workstation. For demonstration purposes, certificate verification is disabled using the `-k` curl flag; however, this is not recommended outside of testing purposes. Refer to [Setup your own certificate](/docs/deploy-manage/security/k8s-https-settings#k8s-setting-up-your-own-certificate) for more information.
   - From inside the Kubernetes cluster:
  ```sh
  curl -u "elastic:$PASSWORD" -k "<ELASTICSEARCH_HOST_URL>:9200"
  ```
- From your local workstation:
  1. Use the following command in a separate terminal:
   ```sh
   kubectl port-forward service/quickstart-es-http 9200
   ```
2. Request `localhost`:
   ```sh
   curl -u "elastic:$PASSWORD" -k "https://localhost:9200"
   ```


## Next steps

This completes the quickstart of deploying an Elasticsearch cluster. We recommend continuing to:
- [Deploy a Kibana instance](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/kibana-instance-quickstart)
- For information about how to apply changes to your deployments, refer to [applying updates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/update-deployments).
- To explore other configuration options for your Elasticsearch cluster, see [Elasticsearch configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-configuration) and [Configure deployments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-deployments).