﻿---
title: Elasticsearch configuration
description: This section covers various Elasticsearch cluster configuration scenarios when using ECK. For configuration topics relevant to both Elasticsearch and...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-configuration
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Elasticsearch configuration
This section covers various Elasticsearch cluster configuration scenarios when using ECK. For configuration topics relevant to both Elasticsearch and Kibana, see the [Configure deployments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-deployments).
Before deploying and running ECK in production, review the basic and advanced settings available on this page. These configurations integrate Elasticsearch, Kubernetes, and ECK operator functionality to help you fine-tune your deployment.

## Key concepts

- [Nodes orchestration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/nodes-orchestration): Learn how ECK orchestrates nodes, applies changes or upgrades the cluster.
- [Storage recommendations](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/storage-recommendations): Kubernetes storage considerations for Elasticsearch workloads.


## Basic Elasticsearch settings

- [Node configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/node-configuration): Configure the `elasticsearch.yml` of your Elasticsearch nodes.
- [Volume claim templates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/volume-claim-templates): Configure storage in your Elasticsearch nodes.
- [Virtual memory](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/virtual-memory): Methods to accomplish Elasticsearch virtual memory system configuration requirement.
- [Secure settings](https://www.elastic.co/docs/deploy-manage/security/k8s-secure-settings): Configure the Elasticsearch keystore through Kubernetes secrets.
- [Settings managed by ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/settings-managed-by-eck): List of Elasticsearch settings that you shouldn't update.
- [Custom configuration files and plugins](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/custom-configuration-files-plugins): Add extra configuration files or install plugins to your Elasticsearch nodes.
- [Init containers for plugin downloads](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/init-containers-for-plugin-downloads): Use Kubernetes init containers to install plugins before starting Elasticsearch.


## Scheduling and lifecycle management

- [Advanced Elasticsearch node scheduling](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/advanced-elasticsearch-node-scheduling): Integrate standard Kubernetes scheduling options with your Elasticsearch nodes.
- [Update strategy](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/update-strategy): Control how the changes are applied to the cluster.
- [Pod disruption budget](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/pod-disruption-budget): Integrate Kubernetes Pod disruption budgets in your cluster.
- [Security Context](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/security-context): Kubernetes security context and kernel capabilities.
- [Readiness probe](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/readiness-probe): Customize `readinessProbe` in certain use cases.
- [Pod PreStop hook](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/pod-prestop-hook): Prevent disruptions when terminating Elasticsearch Pods.


## TLS/SSL Certificates

- [Secure HTTP communications](https://www.elastic.co/docs/deploy-manage/security/secure-cluster-communications): Customize the service and TLS certificates used for transport traffic.
- [Transport settings](https://www.elastic.co/docs/deploy-manage/security/k8s-transport-settings): Customize the service and TLS certificates used for transport traffic.


## Traffic handling

- [Requests routing to Elasticsearch nodes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/requests-routing-to-elasticsearch-nodes): Control the nodes receiving incoming traffic when using multiple `nodeSets` with different [node roles](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles).


## Other sections

Other sections of the documentation also include relevant configuration options for your Elasticsearch cluster:
- [Users and roles](https://www.elastic.co/docs/deploy-manage/users-roles)
- [Snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-on-k8s)
- [Remote clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters/eck-remote-clusters)
- [Autoscaling](/docs/deploy-manage/autoscaling/autoscaling-in-eck#k8s-autoscaling)
- [Stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/eck-stack-monitoring): Monitor your Elasticsearch cluster smoothly with the help of ECK.
- [Troubleshoot](https://www.elastic.co/docs/troubleshoot/deployments/cloud-on-k8s/kubernetes)