﻿---
title: Elastic Maps Server
description: If you cannot connect to Elastic Maps Service from the Kibana server or browser clients, and you are running ECK with an Enterprise license, you can opt...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elastic-maps-server
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Elastic Maps Server
<warning>
  This functionality is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</warning>

If you cannot connect to Elastic Maps Service from the Kibana server or browser clients, and you are running ECK with an Enterprise license, you can opt to host the service on your Kubernetes cluster. Check also the [Elastic Maps Server documentation.](/docs/explore-analyze/visualize/maps/maps-connect-to-ems#elastic-maps-server)
The following sections describe how to customize an Elastic Maps Server deployment to suit your requirements.
- [Deploy Elastic Maps Server](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/deploy-elastic-maps-server)
- [Map data](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/map-data)
  - [Basemap Download](/docs/deploy-manage/deploy/cloud-on-k8s/map-data#k8s-maps-basemap-download)
- [Pod Configuration](/docs/deploy-manage/deploy/cloud-on-k8s/map-data#k8s-maps-pod-configuration)
- [Advanced configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/advanced-configuration-maps-server)
  - [Elastic Maps Server configuration](/docs/deploy-manage/deploy/cloud-on-k8s/advanced-configuration-maps-server#k8s-maps-configuration)
- [Scale out an Elastic Maps Server deployment](/docs/deploy-manage/deploy/cloud-on-k8s/advanced-configuration-maps-server#k8s-maps-scaling)
- [HTTP Configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/http-configuration)
  - [Load balancer settings and TLS SANs](/docs/deploy-manage/deploy/cloud-on-k8s/http-configuration#k8s-maps-http-publish)
- [Provide your own certificate](/docs/deploy-manage/deploy/cloud-on-k8s/http-configuration#k8s-maps-http-custom-tls)
- [Disable TLS](/docs/deploy-manage/deploy/cloud-on-k8s/http-configuration#k8s-maps-http-disable-tls)
- [Ingress and Kibana configuration](/docs/deploy-manage/deploy/cloud-on-k8s/http-configuration#k8s-maps-ingress)

<admonition title="Support scope for Ingress Controllers">
  [Ingress](https://kubernetes.io/docs/concepts/services-networking/ingress/) is a standard Kubernetes concept. While ECK-managed workloads can be publicly exposed using ingress resources, and we provide [example configurations](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/recipes), setting up an Ingress controller requires in-house Kubernetes expertise.If ingress configuration is challenging or unsupported in your environment, consider using standard `LoadBalancer` services as a simpler alternative.
</admonition>