﻿---
title: Deploy a FIPS compatible version of ECK
description: The Federal Information Processing Standard (FIPS) Publication 140-2, (FIPS PUB 140-2), titled "Security Requirements for Cryptographic Modules" is a...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/deploy-fips-compatible-version-of-eck
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Deploy a FIPS compatible version of ECK
The Federal Information Processing Standard (FIPS) Publication 140-2, (FIPS PUB 140-2), titled "Security Requirements for Cryptographic Modules" is a U.S. government computer security standard used to approve cryptographic modules. Since version 2.6 ECK offers a FIPS-enabled image that is a drop-in replacement for the standard image.
For the ECK operator, adherence to FIPS 140-2 is ensured by:
- Using FIPS approved / NIST recommended cryptographic algorithms.
- Compiling the operator using the [BoringCrypto](https://github.com/golang/go/blob/dev.boringcrypto/README.boringcrypto.md) library for various cryptographic primitives.


## FIPS compliant installation using Helm

Set `image.fips=true` to install a FIPS-enabled version of the ECK Operator. Refer to [Install ECK using the Helm chart](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/install-using-helm-chart) for full Helm installation instructions.
```sh
helm install elastic-operator elastic/eck-operator \
  -n elastic-system --create-namespace \
  --set=image.fips=true
```


## FIPS compliant installation using manifests

The `StatefulSet` definition within the yaml installation manifest will need to be patched prior to installation to append `-fips` to the `spec.template.spec.containers[*].image` to install a FIPS-enabled version of the ECK Operator. Refer to [Install ECK using the YAML manifests](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/install-using-yaml-manifest-quickstart) for full manifest installation instructions.
<note>
  `${ECK_VERSION}` in the following command needs to be replaced with the version of the Operator that is to be installed.
</note>

```sh
curl -s https://download.elastic.co/downloads/eck/${ECK_VERSION}/operator.yaml | sed -r 's#(image:.*eck-operator)(:.*)#\1-fips\2#' | kubectl apply -f -
```

If the Operator has already been installed using the manifests, the installation can be patched instead:
```sh
kubectl patch sts elastic-operator -n elastic-system -p '{"spec":{"template":{"spec":{"containers":[{"name":"manager", "image":"docker.elastic.co/eck/eck-operator-fips:${ECK_VERSION}"}]}}}}'
```