﻿---
title: Deploy ECK on Openshift
description: This section shows how to run ECK on OpenShift. Before you begin, Deploy the operator, Deploy an Elasticsearch instance with a route, Deploy a Kibana...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/deploy-eck-on-openshift
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Deploy ECK on Openshift
This section shows how to run ECK on OpenShift.
- [Before you begin](#k8s-openshift-before-you-begin)
- [Deploy the operator](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-openshift-deploy-operator)
- [Deploy an Elasticsearch instance with a route](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-openshift-deploy-elasticsearch)
- [Deploy a Kibana instance with a route](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-openshift-deploy-kibana)
- [Deploy Docker images with `anyuid` SCC](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-openshift-anyuid-workaround)
- [Grant privileged permissions to Beats](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-openshift-beats)
- [Grant host access permission to Elastic Agent](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/k8s-openshift-agent)


## Before you begin

1. To run the instructions on this page, you must be a `system:admin` user or a user with the privileges to create Projects, CRDs, and RBAC resources at the cluster level.
2. Set virtual memory settings on the Kubernetes nodes.
   Before deploying an Elasticsearch cluster with ECK, make sure that the Kubernetes nodes in your cluster have the correct `vm.max_map_count` sysctl setting applied. By default, Pods created by ECK are likely to run with the `restricted` [Security Context Constraint](https://docs.openshift.com/container-platform/4.12/authentication/managing-security-context-constraints.html) (SCC) which restricts privileged access required to change this setting in the underlying Kubernetes nodes.
   Alternatively, you can opt for setting `node.store.allow_mmap: false` at the [Elasticsearch node configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/node-configuration) level. This has performance implications and is not recommended for production workloads.
   For more information, check [Virtual memory](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/virtual-memory).