﻿---
title: Deploy ECK on GKE Autopilot
description: This page shows how to run ECK on GKE Autopilot. It is recommended that each Kubernetes host’s virtual memory kernel settings be modified. Refer to Virtual...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/deploy-eck-on-gke-autopilot
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Deploy ECK on GKE Autopilot
This page shows how to run ECK on GKE Autopilot.
1. It is recommended that each Kubernetes host’s virtual memory kernel settings be modified. Refer to [Virtual memory](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/virtual-memory).
2. It is recommended that Elasticsearch Pods have an `initContainer` that waits for virtual memory settings to be in place.
3. For Elastic Agent/Beats there are storage limitations to be considered.
4. Ensure you are using a node class that is applicable for your workload by adding a `cloud.google.com/compute-class` label in a `nodeSelector`. Refer to [GKE Autopilot documentation](https://cloud.google.com/kubernetes-engine/docs/concepts/autopilot-compute-classes).


## Ensuring virtual memory kernel settings

If you are intending to run production workloads on GKE Autopilot then `vm.max_map_count` should be set. The recommended way to set this kernel setting on the Autopilot hosts depends on your GKE version:
- **GKE 1.30.3-gke.1451000 or later**: [Use a custom ComputeClass](/docs/deploy-manage/deploy/cloud-on-k8s/virtual-memory#k8s_using_a_computeclass_to_set_virtual_memory). Using a custom ComputeClass allows you to set a higher value for `vm.max_map_count`, avoiding the limitations of the `DaemonSet` approach.
- **Earlier versions**: [Use a DaemonSet](/docs/deploy-manage/deploy/cloud-on-k8s/virtual-memory#k8s_using_a_daemonset_to_set_virtual_memory). You must be running at least version 1.25 when on the `regular` channel or using the `rapid` channel, which currently runs version 1.27.
  <warning>
  Use the provided `Daemonset` exactly as specified, with a `vm.max_map_count` value of `262144`, or it could be rejected by the Autopilot control plane.
  </warning>


## Install the ECK Operator

Refer to [*Install ECK*](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/install) for more information on installation options.

## Deploy an Elasticsearch cluster

Create an Elasticsearch cluster. The information that you need to provide in your spec depends on whether you've increased your virtual memory kernel setting, and the method that you used.
<tab-set>
  <tab-item title="Using a custom ComputeClass">
    If you used a custom ComputeClass to set `vm.max_map_count`, then you need to reference the custom ComputeClass as part of your template spec.
    ```yaml
    cat <<EOF | kubectl apply -f -
    apiVersion: elasticsearch.k8s.elastic.co/v1
    kind: Elasticsearch
    metadata:
      name: elasticsearch-sample
    spec:
      version: 9.3.0
      nodeSets:
      - name: default
        count: 1
        podTemplate:
          spec:
            nodeSelector:
              cloud.google.com/compute-class: "elasticsearch"
    EOF
    ```
  </tab-item>

  <tab-item title="Using a DaemonSet">
    If you used a DaemonSet to set `max_map_count`, you can add the following `initContainer` to ensure the setting is set prior to starting Elasticsearch.
    ```yaml
    cat <<EOF | kubectl apply -f -
    apiVersion: elasticsearch.k8s.elastic.co/v1
    kind: Elasticsearch
    metadata:
      name: elasticsearch-sample
    spec:
      version: 9.3.0
      nodeSets:
      - name: default
        count: 1
        podTemplate:
          spec:
            # This init container ensures that the `max_map_count` setting has been applied before starting Elasticsearch.
            # This is not required, but is encouraged when using the Daemonset to set max_map_count.
            # Do not use this if setting config.node.store.allow_mmap: false
            initContainers:
            - name: max-map-count-check
              command: ['sh', '-c', "while true; do mmc=$(cat /proc/sys/vm/max_map_count); if [ ${mmc} -eq 262144 ]; then exit 0; fi; sleep 1; done"]     
    EOF
    ```
  </tab-item>
</tab-set>


### Deploy without custom virtual memory

If you didn't increase your virtual memory, then you need to set `node.store.allow_mmap` to `false`.
```yaml
cat <<EOF | kubectl apply -f -
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
metadata:
  name: elasticsearch-sample
spec:
  version: 9.3.0
  nodeSets:
  - name: default
    count: 1 
    config:
      node.store.allow_mmap: false
EOF
```


## Deploy a standalone Elastic Agent and/or Beats

When running Elastic Agent and Beats within GKE Autopilot there are storage constraints to be considered. No `HostPath` volumes are allowed, which the ECK operator defaults to when unset for both `Deployments` and `DaemonSets`. Instead use [Kubernetes ephemeral volumes](https://kubernetes.io/docs/concepts/storage/ephemeral-volumes).
Refer to [Recipes to deploy Elasticsearch, Kibana, Elastic Fleet Server and Elastic Agent and/or Beats within GKE Autopilot](https://github.com/elastic/cloud-on-k8s/tree/main/config/recipes/autopilot).