﻿---
title: Customize pods
description: You can customize the Pods created for each Elastic Stack application by modifying the respective podTemplate field in the manifest. Pod templates allow...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/customize-pods
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Customize pods
You can customize the Pods created for each Elastic Stack application by modifying the respective `podTemplate` field in the manifest. Pod templates allow you to define labels, annotations, environment variables, volume mounts, and other custom configuration settings that are then merged with the default Pod configuration generated by ECK to produce the final Pod definition that gets deployed to the Kubernetes cluster.
The following example illustrates how to add a custom label, annotation, and an environment variable using the `podTemplate` field.
```yaml
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
metadata:
  name: quickstart
spec:
  version: 9.3.0
  nodeSets:
  - name: default
    count: 1
    podTemplate:
      metadata:
        labels:
          my.custom.domain/label: "label-value"
        annotations:
          my.custom.domain/annotation: "annotation-value"
      spec:
        containers:
          - name: elasticsearch
            env:
              - name: ES_JAVA_OPTS
                value: "-Xms4g -Xmx4g"
```

```yaml
apiVersion: kibana.k8s.elastic.co/v1
kind: Kibana
metadata:
  name: quickstart
spec:
  version: 9.3.0
  count: 1
  podTemplate:
    metadata:
      labels:
        my.custom.domain/label: "label-value"
      annotations:
        my.custom.domain/annotation: "annotation-value"
    spec:
      containers:
        - name: kibana
          env:
            - name: NODE_OPTIONS
              value:  "--max-old-space-size=2048"
```

<note>
  Configuration for other Elastic Stack applications, like APM Server, or Beats, is identical to the Kibana configuration except for the `apiVersion` and `kind` fields.
</note>

The following example shows how it’s also possible to customize the init containers created as part of the Pods to initialize the filesystem or to manage the keystores.
```yaml
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
metadata:
  name: quickstart
spec:
  version: 9.3.0
  nodeSets:
    - name: default
      count: 3
      podTemplate:
        spec:
          initContainers:
          - name: elastic-internal-init-keystore
            resources:
              limits:
                cpu: 1000m
                memory: 368Mi
              requests:
                cpu: 1000m
                memory: 368Mi
  secureSettings:
  - secretName: es-secret
```


## More examples

- [Init containers for plugin downloads](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/init-containers-for-plugin-downloads)
- [*Manage compute resources*](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/manage-compute-resources)

For further information:
- [Pod templates overview](https://kubernetes.io/docs/concepts/workloads/pods/pod-overview/#pod-templates)
- [Pod template spec API reference](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.25/#podtemplatespec-v1-core)